/*
 * Decompiled with CFR 0.152.
 */
package ru.reliabletech.zuul.swagger;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import ru.reliabletech.zuul.swagger.ServiceInfo;

@ConfigurationProperties(prefix="zuul")
public class ServicesSwaggerInfo {
    public static final String DEFAULT_SWAGGER_API_URL = "v2/api-docs";
    private String prefix;
    private String defaultSwaggerUrl = "v2/api-docs";
    private Map<String, ServiceInfo> routes = new HashMap<String, ServiceInfo>();

    public Set<String> getRouteNames() {
        return this.routes.keySet();
    }

    public String getSwaggerUrl(String route) {
        return Optional.ofNullable(this.routes.get(route)).map(ServiceInfo::getSwaggerUrl).orElse(this.defaultSwaggerUrl);
    }

    public String getServiceUrl(String route) {
        return Optional.ofNullable(this.routes.get(route)).map(ServiceInfo::getServiceUrl).orElse("");
    }

    public Optional<String> getServicePath(String route) {
        return Optional.ofNullable(this.routes.get(route)).map(ServiceInfo::getPath);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDefaultSwaggerUrl() {
        return this.defaultSwaggerUrl;
    }

    public Map<String, ServiceInfo> getRoutes() {
        return this.routes;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDefaultSwaggerUrl(String defaultSwaggerUrl) {
        this.defaultSwaggerUrl = defaultSwaggerUrl;
    }

    public void setRoutes(Map<String, ServiceInfo> routes) {
        this.routes = routes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServicesSwaggerInfo)) {
            return false;
        }
        ServicesSwaggerInfo other = (ServicesSwaggerInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$defaultSwaggerUrl = this.getDefaultSwaggerUrl();
        String other$defaultSwaggerUrl = other.getDefaultSwaggerUrl();
        if (this$defaultSwaggerUrl == null ? other$defaultSwaggerUrl != null : !this$defaultSwaggerUrl.equals(other$defaultSwaggerUrl)) {
            return false;
        }
        Map<String, ServiceInfo> this$routes = this.getRoutes();
        Map<String, ServiceInfo> other$routes = other.getRoutes();
        return !(this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServicesSwaggerInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $defaultSwaggerUrl = this.getDefaultSwaggerUrl();
        result = result * 59 + ($defaultSwaggerUrl == null ? 43 : $defaultSwaggerUrl.hashCode());
        Map<String, ServiceInfo> $routes = this.getRoutes();
        result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
        return result;
    }

    public String toString() {
        return "ServicesSwaggerInfo(prefix=" + this.getPrefix() + ", defaultSwaggerUrl=" + this.getDefaultSwaggerUrl() + ", routes=" + this.getRoutes() + ")";
    }
}

