/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter.caps;

import java.util.Map;
import org.springframework.stereotype.Service;
import ru.qatools.gridrouter.caps.CapabilityProcessor;
import ru.qatools.gridrouter.json.JsonCapabilities;

@Service
public class AppiumCapabilityProcessor
implements CapabilityProcessor {
    private static final String PLATFORM_NAME = "platformName";
    private static final String IOS = "iOS";

    @Override
    public boolean accept(JsonCapabilities caps) {
        return caps.getBrowserName().isEmpty() && this.isMac(caps);
    }

    @Override
    public void process(JsonCapabilities caps) {
        caps.any().put("keepKeyChains", true);
    }

    private boolean isMac(JsonCapabilities jsonCapabilities) {
        Map<String, Object> capsMap = jsonCapabilities.any();
        return capsMap.containsKey(PLATFORM_NAME) && String.valueOf(capsMap.get(PLATFORM_NAME)).contains(IOS);
    }
}

