/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public final class JsonWireUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonWireUtils.class);
    public static final String WD_HUB_SESSION = "/wd/hub/session/";
    public static final int SESSION_HASH_LENGTH = 32;

    private JsonWireUtils() {
    }

    public static boolean isUriValid(String uri) {
        return uri.length() > JsonWireUtils.getUriPrefixLength();
    }

    public static boolean isSessionDeleteRequest(HttpServletRequest request, String command) {
        return HttpMethod.DELETE.name().equalsIgnoreCase(request.getMethod()) && !command.contains("/");
    }

    public static String getSessionHash(String uri) {
        return uri.substring(WD_HUB_SESSION.length(), JsonWireUtils.getUriPrefixLength());
    }

    public static String getFullSessionId(String uri) {
        String tail = uri.substring(WD_HUB_SESSION.length());
        int end = tail.indexOf(47);
        if (end < 0) {
            return tail;
        }
        return tail.substring(0, end);
    }

    public static int getUriPrefixLength() {
        return WD_HUB_SESSION.length() + 32;
    }

    public static String redirectionUrl(String host, String command) throws URISyntaxException {
        return new URIBuilder(host).setPath(WD_HUB_SESSION + command).build().toString();
    }

    public static String getCommand(String uri) {
        String encodedCommand = uri.substring(JsonWireUtils.getUriPrefixLength());
        try {
            return URLDecoder.decode(encodedCommand, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("[UNABLE_TO_DECODE_COMMAND] - could not decode command: {}", (Object)encodedCommand, (Object)e);
            return encodedCommand;
        }
    }
}

