/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import ru.qatools.beanloader.BeanChangeListener;
import ru.qatools.beanloader.BeanLoader;
import ru.qatools.beanloader.BeanWatcher;
import ru.qatools.gridrouter.ConfigRepository;
import ru.qatools.gridrouter.config.Browsers;

public class ConfigRepositoryXml
implements ConfigRepository,
BeanChangeListener<Browsers> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRepositoryXml.class);
    private static final String XML_GLOB = "*.xml";
    @Value(value="${grid.config.quota.directory}")
    private File quotaDirectory;
    @Value(value="${grid.config.quota.hotReload}")
    private boolean quotaHotReload;
    private Map<String, Browsers> userBrowsers = new HashMap<String, Browsers>();
    private Map<String, String> routes = new HashMap<String, String>();

    @PostConstruct
    public void init() {
        try {
            if (this.quotaHotReload) {
                LOGGER.debug("Starting quota watcher");
                BeanWatcher.watchFor(Browsers.class, (Path)this.quotaDirectory.toPath(), (String)XML_GLOB, (BeanChangeListener)this);
            } else {
                LOGGER.debug("Loading quota configuration");
                BeanLoader.loadAll(Browsers.class, (Path)this.quotaDirectory.toPath(), (String)XML_GLOB, (BeanChangeListener)this);
            }
        }
        catch (IOException e) {
            LOGGER.error("Quota configuration loading failed", (Throwable)e);
        }
    }

    public void beanChanged(Path filename, Browsers browsers) {
        if (browsers == null) {
            LOGGER.info("Configuration file [{}] was deleted. It is not purged from the running gridrouter process though.", (Object)filename);
        } else {
            LOGGER.info("Loading quota configuration file [{}]", (Object)filename);
            String user = FilenameUtils.getBaseName((String)filename.toString());
            this.userBrowsers.put(user, browsers);
            this.routes.putAll(browsers.getRoutesMap());
            LOGGER.info("Loaded quota configuration for [{}] from [{}]: \n\n{}", new Object[]{user, filename, browsers.toXml()});
        }
    }

    @Override
    public Map<String, Browsers> getQuotaMap() {
        return this.userBrowsers;
    }

    @Override
    public String getRoute(String routeId) {
        return this.routes.get(routeId);
    }
}

