/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter;

import java.util.HashMap;
import java.util.Map;
import ru.qatools.gridrouter.config.Browser;
import ru.qatools.gridrouter.config.Browsers;
import ru.qatools.gridrouter.config.Version;
import ru.qatools.gridrouter.json.JsonCapabilities;

public interface ConfigRepository {
    public Map<String, Browsers> getQuotaMap();

    public String getRoute(String var1);

    default public Version findVersion(String user, JsonCapabilities caps) {
        Browsers browsers = this.getQuotaMap().get(user);
        return browsers != null ? browsers.find(caps.getBrowserName(), caps.getVersion()) : null;
    }

    default public Map<String, Integer> getBrowsersCountMap(String user) {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (Browser browser : this.getQuotaMap().get(user).getBrowsers()) {
            for (Version version : browser.getVersions()) {
                countMap.put(browser.getName() + ":" + version.getNumber(), version.getCount());
            }
        }
        return countMap;
    }
}

