/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.properties.converters;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.qatools.properties.converters.ArrayConverter;
import ru.qatools.properties.converters.BooleanConverter;
import ru.qatools.properties.converters.ByteConverter;
import ru.qatools.properties.converters.CharacterConverter;
import ru.qatools.properties.converters.CharsetConverter;
import ru.qatools.properties.converters.CollectionConverter;
import ru.qatools.properties.converters.ConversionException;
import ru.qatools.properties.converters.Converter;
import ru.qatools.properties.converters.DoubleConverter;
import ru.qatools.properties.converters.EnumConverter;
import ru.qatools.properties.converters.FloatConverter;
import ru.qatools.properties.converters.IntegerConverter;
import ru.qatools.properties.converters.LongConverter;
import ru.qatools.properties.converters.RegexStringSplitter;
import ru.qatools.properties.converters.ShortConverter;
import ru.qatools.properties.converters.StringConverter;
import ru.qatools.properties.converters.StringSplitter;
import ru.qatools.properties.converters.UriConverter;
import ru.qatools.properties.converters.UrlConverter;

public class ConverterManager {
    public static final String COMMA = ",";
    private final Map<Class, Converter> storage = new HashMap<Class, Converter>();
    private StringSplitter stringSplitter;

    public ConverterManager() {
        this(new RegexStringSplitter(COMMA));
    }

    public ConverterManager(StringSplitter stringSplitter) {
        this.stringSplitter = stringSplitter;
        this.registerDefaults();
    }

    protected void registerDefaults() {
        this.register(Long.class, new LongConverter());
        this.register(Integer.class, new IntegerConverter());
        this.register(Short.class, new ShortConverter());
        this.register(Byte.class, new ByteConverter());
        this.register(Double.class, new DoubleConverter());
        this.register(Float.class, new FloatConverter());
        this.register(Character.class, new CharacterConverter());
        this.register(Boolean.class, new BooleanConverter());
        this.register(String.class, new StringConverter());
        this.register(URL.class, new UrlConverter());
        this.register(URI.class, new UriConverter());
        this.register(Charset.class, new CharsetConverter());
        this.register(Long.TYPE, new LongConverter());
        this.register(Integer.TYPE, new IntegerConverter());
        this.register(Short.TYPE, new ShortConverter());
        this.register(Byte.TYPE, new ByteConverter());
        this.register(Character.TYPE, new CharacterConverter());
        this.register(Double.TYPE, new DoubleConverter());
        this.register(Float.TYPE, new FloatConverter());
        this.register(Boolean.TYPE, new BooleanConverter());
    }

    public <T> void register(Class<T> type, Converter<T> converter) {
        this.addConverter(type, converter);
    }

    protected <T> void addConverter(Class<T> type, Converter<T> converter) {
        this.storage.put(type, converter);
    }

    protected <T> Converter<T> find(Class<T> type) throws ConversionException {
        if (type.isEnum()) {
            return new EnumConverter(type);
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            Converter<?> childConverter = this.find(componentType);
            return new ArrayConverter(childConverter, componentType, this.stringSplitter);
        }
        Converter converter = this.storage.get(type);
        if (converter == null) {
            throw new ConversionException(String.format("Could not find converter for type <%s>", type));
        }
        return converter;
    }

    public Object convert(Class<?> type, String origin) throws ConversionException {
        if (origin == null) {
            return this.convertNullValue(type);
        }
        Converter<?> converter = this.find(type);
        try {
            return converter.convert(origin);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Could not convert string <%s> to type <%s>", origin, type), e);
        }
    }

    protected Object convertNullValue(Class type) throws ConversionException {
        try {
            return type.isPrimitive() ? Array.get(Array.newInstance(type, 1), 0) : null;
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Could not convert null to primitive type <%s>", type), e);
        }
    }

    public <T> Object convert(Class collectionType, Class<T> elementType, String origin) throws ConversionException {
        Converter<T> elementConverter = this.find(elementType);
        CollectionConverter<T> converter = new CollectionConverter<T>(elementConverter, this.stringSplitter);
        try {
            Object converted = converter.convert(origin);
            return this.castCollectionToType(collectionType, (Collection<T>)converted);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Could not convert string <%s> to collection <%s> with element type <%s>", origin, collectionType, elementType), e);
        }
    }

    protected <T> Collection<T> castCollectionToType(Class collectionType, Collection<T> converted) throws ConversionException {
        if (!Collection.class.isAssignableFrom(collectionType)) {
            throw new ConversionException("Collection type should extends collection" + collectionType);
        }
        if (collectionType.isInterface()) {
            if (collectionType.isAssignableFrom(Set.class)) {
                return Collections.unmodifiableSet(new HashSet<T>(converted));
            }
            if (collectionType.isAssignableFrom(List.class)) {
                return Collections.unmodifiableList(new LinkedList<T>(converted));
            }
            if (collectionType.isAssignableFrom(Collection.class)) {
                return Collections.unmodifiableCollection(converted);
            }
            throw new ConversionException("Unsupported collection type " + collectionType);
        }
        try {
            Constructor constructor = collectionType.getConstructor(Collection.class);
            return (Collection)constructor.newInstance(converted);
        }
        catch (Exception e) {
            throw new ConversionException("Could not create an instance of " + collectionType, e);
        }
    }
}

