/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.priority;

import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.noties.markwon.MarkwonPlugin;
import ru.noties.markwon.priority.PriorityProcessor;

class PriorityProcessorImpl
extends PriorityProcessor {
    PriorityProcessorImpl() {
    }

    @Override
    @NonNull
    public List<MarkwonPlugin> process(@NonNull List<MarkwonPlugin> in) {
        ArrayList<MarkwonPlugin> plugins = new ArrayList<MarkwonPlugin>(in);
        int size = plugins.size();
        HashMap<Class<? extends MarkwonPlugin>, Set<Class<? extends MarkwonPlugin>>> map = new HashMap<Class<? extends MarkwonPlugin>, Set<Class<? extends MarkwonPlugin>>>(size);
        for (MarkwonPlugin plugin : plugins) {
            if (map.put(plugin.getClass(), new HashSet<Class<? extends MarkwonPlugin>>(plugin.priority().after())) == null) continue;
            throw new IllegalStateException(String.format("Markwon duplicate plugin found `%s`: %s", plugin.getClass().getName(), plugin));
        }
        HashMap<MarkwonPlugin, Integer> cache = new HashMap<MarkwonPlugin, Integer>(size);
        for (MarkwonPlugin plugin : plugins) {
            cache.put(plugin, PriorityProcessorImpl.eval(plugin, map));
        }
        Collections.sort(plugins, new PriorityComparator(cache));
        return plugins;
    }

    private static int eval(@NonNull MarkwonPlugin plugin, @NonNull Map<Class<? extends MarkwonPlugin>, Set<Class<? extends MarkwonPlugin>>> map) {
        Set<Class<? extends MarkwonPlugin>> set = map.get(plugin.getClass());
        if (set.isEmpty()) {
            return 0;
        }
        Class<?> who = plugin.getClass();
        int max = 0;
        for (Class<? extends MarkwonPlugin> dependency : set) {
            max = Math.max(max, PriorityProcessorImpl.eval(who, dependency, map));
        }
        return 1 + max;
    }

    private static int eval(@NonNull Class<? extends MarkwonPlugin> who, @NonNull Class<? extends MarkwonPlugin> plugin, @NonNull Map<Class<? extends MarkwonPlugin>, Set<Class<? extends MarkwonPlugin>>> map) {
        Set<Class<? extends MarkwonPlugin>> set = map.get(plugin);
        if (set == null) {
            for (Map.Entry<Class<? extends MarkwonPlugin>, Set<Class<? extends MarkwonPlugin>>> entry : map.entrySet()) {
                if (!plugin.isAssignableFrom(entry.getKey())) continue;
                set = entry.getValue();
                break;
            }
            if (set == null) {
                throw new IllegalStateException(String.format("Markwon unsatisfied dependency found. Plugin `%s` comes after `%s` but it is not added.", who.getName(), plugin.getName()));
            }
        }
        if (set.isEmpty()) {
            return 0;
        }
        int value = 1;
        for (Class<? extends MarkwonPlugin> dependency : set) {
            if (who.equals(dependency)) {
                throw new IllegalStateException(String.format("Markwon plugin `%s` defined self as a dependency or being referenced by own dependency (cycle)", who.getName()));
            }
            value += PriorityProcessorImpl.eval(who, dependency, map);
        }
        return value;
    }

    private static class PriorityComparator
    implements Comparator<MarkwonPlugin> {
        private final Map<MarkwonPlugin, Integer> map;

        PriorityComparator(@NonNull Map<MarkwonPlugin, Integer> map) {
            this.map = map;
        }

        @Override
        public int compare(MarkwonPlugin o1, MarkwonPlugin o2) {
            return this.map.get(o1).compareTo(this.map.get(o2));
        }
    }
}

