/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image.network;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import ru.noties.markwon.image.ImageItem;
import ru.noties.markwon.image.SchemeHandler;

public class NetworkSchemeHandler
extends SchemeHandler {
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";

    @NonNull
    public static NetworkSchemeHandler create() {
        return new NetworkSchemeHandler();
    }

    @Override
    @Nullable
    public ImageItem handle(@NonNull String raw, @NonNull Uri uri) {
        try {
            URL url = new URL(raw);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                String contentType = NetworkSchemeHandler.contentType(connection.getHeaderField("Content-Type"));
                BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
                return new ImageItem(contentType, inputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Nullable
    static String contentType(@Nullable String contentType) {
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(59);
        if (index > -1) {
            return contentType.substring(0, index);
        }
        return contentType;
    }
}

