/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image.file;

import android.content.res.AssetManager;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.webkit.MimeTypeMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import ru.noties.markwon.image.ImageItem;
import ru.noties.markwon.image.SchemeHandler;

public class FileSchemeHandler
extends SchemeHandler {
    public static final String SCHEME = "file";
    private static final String FILE_ANDROID_ASSETS = "android_asset";
    @Nullable
    private final AssetManager assetManager;

    @NonNull
    public static FileSchemeHandler createWithAssets(@NonNull AssetManager assetManager) {
        return new FileSchemeHandler(assetManager);
    }

    @NonNull
    public static FileSchemeHandler create() {
        return new FileSchemeHandler(null);
    }

    FileSchemeHandler(@Nullable AssetManager assetManager) {
        this.assetManager = assetManager;
    }

    @Override
    @Nullable
    public ImageItem handle(@NonNull String raw, @NonNull Uri uri) {
        ImageItem out;
        List segments = uri.getPathSegments();
        if (segments == null || segments.size() == 0) {
            return null;
        }
        InputStream inputStream = null;
        boolean assets = FILE_ANDROID_ASSETS.equals(segments.get(0));
        String fileName = uri.getLastPathSegment();
        if (assets) {
            if (this.assetManager != null) {
                StringBuilder path = new StringBuilder();
                int size = segments.size();
                for (int i = 1; i < size; ++i) {
                    if (i != 1) {
                        path.append('/');
                    }
                    path.append((String)segments.get(i));
                }
                try {
                    inputStream = this.assetManager.open(path.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                inputStream = new BufferedInputStream(new FileInputStream(new File(uri.getPath())));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (inputStream != null) {
            String contentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)fileName));
            out = new ImageItem(contentType, inputStream);
        } else {
            out = null;
        }
        return out;
    }
}

