/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image.data;

import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.ByteArrayInputStream;
import ru.noties.markwon.image.ImageItem;
import ru.noties.markwon.image.SchemeHandler;
import ru.noties.markwon.image.data.DataUri;
import ru.noties.markwon.image.data.DataUriDecoder;
import ru.noties.markwon.image.data.DataUriParser;

public class DataUriSchemeHandler
extends SchemeHandler {
    public static final String SCHEME = "data";
    private static final String START = "data:";
    private final DataUriParser uriParser;
    private final DataUriDecoder uriDecoder;

    @NonNull
    public static DataUriSchemeHandler create() {
        return new DataUriSchemeHandler(DataUriParser.create(), DataUriDecoder.create());
    }

    DataUriSchemeHandler(@NonNull DataUriParser uriParser, @NonNull DataUriDecoder uriDecoder) {
        this.uriParser = uriParser;
        this.uriDecoder = uriDecoder;
    }

    @Override
    @Nullable
    public ImageItem handle(@NonNull String raw, @NonNull Uri uri) {
        DataUri dataUri;
        if (!raw.startsWith(START)) {
            return null;
        }
        String part = raw.substring(START.length());
        if (part.startsWith("//")) {
            part = part.substring(2);
        }
        if ((dataUri = this.uriParser.parse(part)) == null) {
            return null;
        }
        byte[] bytes = this.uriDecoder.decode(dataUri);
        if (bytes == null) {
            return null;
        }
        return new ImageItem(dataUri.contentType(), new ByteArrayInputStream(bytes));
    }
}

