/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image.data;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import ru.noties.markwon.image.data.DataUri;

public abstract class DataUriParser {
    @Nullable
    public abstract DataUri parse(@NonNull String var1);

    @NonNull
    public static DataUriParser create() {
        return new Impl();
    }

    static class Impl
    extends DataUriParser {
        Impl() {
        }

        @Override
        @Nullable
        public DataUri parse(@NonNull String input) {
            String value;
            boolean base64;
            String contentType;
            int index = input.indexOf(44);
            if (index < 0) {
                return null;
            }
            if (index > 0) {
                String part = input.substring(0, index);
                String[] parts = part.split(";");
                int length = parts.length;
                if (length > 0) {
                    if (length == 1) {
                        String value2 = parts[0];
                        if ("base64".equals(value2)) {
                            contentType = null;
                            base64 = true;
                        } else {
                            contentType = value2.indexOf(47) > -1 ? value2 : null;
                            base64 = false;
                        }
                    } else {
                        contentType = parts[0].indexOf(47) > -1 ? parts[0] : null;
                        base64 = "base64".equals(parts[length - 1]);
                    }
                } else {
                    contentType = null;
                    base64 = false;
                }
            } else {
                contentType = null;
                base64 = false;
            }
            String data = index < input.length() ? ((value = input.substring(index + 1, input.length()).replaceAll("\n", "")).length() == 0 ? null : value) : null;
            return new DataUri(contentType, base64, data);
        }
    }
}

