/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image.data;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Base64;
import ru.noties.markwon.image.data.DataUri;

public abstract class DataUriDecoder {
    @Nullable
    public abstract byte[] decode(@NonNull DataUri var1);

    @NonNull
    public static DataUriDecoder create() {
        return new Impl();
    }

    static class Impl
    extends DataUriDecoder {
        Impl() {
        }

        @Override
        @Nullable
        public byte[] decode(@NonNull DataUri dataUri) {
            String data = dataUri.data();
            if (!TextUtils.isEmpty((CharSequence)data)) {
                try {
                    if (dataUri.base64()) {
                        return Base64.decode((byte[])data.getBytes("UTF-8"), (int)0);
                    }
                    return data.getBytes("UTF-8");
                }
                catch (Throwable t) {
                    return null;
                }
            }
            return null;
        }
    }
}

