/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.Spanned;
import android.widget.TextView;
import java.util.Arrays;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.Node;
import ru.noties.markwon.AbstractMarkwonPlugin;
import ru.noties.markwon.MarkwonConfiguration;
import ru.noties.markwon.MarkwonSpansFactory;
import ru.noties.markwon.MarkwonVisitor;
import ru.noties.markwon.RenderProps;
import ru.noties.markwon.SpanFactory;
import ru.noties.markwon.image.AsyncDrawableLoader;
import ru.noties.markwon.image.AsyncDrawableScheduler;
import ru.noties.markwon.image.ImageMediaDecoder;
import ru.noties.markwon.image.ImageProps;
import ru.noties.markwon.image.ImageSpanFactory;
import ru.noties.markwon.image.SchemeHandler;
import ru.noties.markwon.image.data.DataUriSchemeHandler;
import ru.noties.markwon.image.file.FileSchemeHandler;
import ru.noties.markwon.image.network.NetworkSchemeHandler;

public class ImagesPlugin
extends AbstractMarkwonPlugin {
    private final Context context;
    private final boolean useAssets;

    @NonNull
    public static ImagesPlugin create(@NonNull Context context) {
        return new ImagesPlugin(context, false);
    }

    @NonNull
    public static ImagesPlugin createWithAssets(@NonNull Context context) {
        return new ImagesPlugin(context, true);
    }

    protected ImagesPlugin(Context context, boolean useAssets) {
        this.context = context;
        this.useAssets = useAssets;
    }

    @Override
    public void configureImages(@NonNull AsyncDrawableLoader.Builder builder) {
        FileSchemeHandler fileSchemeHandler = this.useAssets ? FileSchemeHandler.createWithAssets(this.context.getAssets()) : FileSchemeHandler.create();
        builder.addSchemeHandler("data", (SchemeHandler)DataUriSchemeHandler.create()).addSchemeHandler("file", (SchemeHandler)fileSchemeHandler).addSchemeHandler(Arrays.asList("http", "https"), (SchemeHandler)NetworkSchemeHandler.create()).defaultMediaDecoder(ImageMediaDecoder.create(this.context.getResources()));
    }

    @Override
    public void configureSpansFactory(@NonNull MarkwonSpansFactory.Builder builder) {
        builder.setFactory(Image.class, new ImageSpanFactory());
    }

    @Override
    public void configureVisitor(@NonNull MarkwonVisitor.Builder builder) {
        builder.on(Image.class, new MarkwonVisitor.NodeVisitor<Image>(){

            @Override
            public void visit(@NonNull MarkwonVisitor visitor, @NonNull Image image) {
                SpanFactory spanFactory = visitor.configuration().spansFactory().get(Image.class);
                if (spanFactory == null) {
                    visitor.visitChildren((Node)image);
                    return;
                }
                int length = visitor.length();
                visitor.visitChildren((Node)image);
                if (length == visitor.length()) {
                    visitor.builder().append('\ufffc');
                }
                MarkwonConfiguration configuration = visitor.configuration();
                Node parent = image.getParent();
                boolean link = parent instanceof Link;
                String destination = configuration.urlProcessor().process(image.getDestination());
                RenderProps props = visitor.renderProps();
                ImageProps.DESTINATION.set(props, destination);
                ImageProps.REPLACEMENT_TEXT_IS_LINK.set(props, link);
                ImageProps.IMAGE_SIZE.set(props, null);
                visitor.setSpans(length, spanFactory.getSpans(configuration, props));
            }
        });
    }

    @Override
    public void beforeSetText(@NonNull TextView textView, @NonNull Spanned markdown) {
        AsyncDrawableScheduler.unschedule(textView);
    }

    @Override
    public void afterSetText(@NonNull TextView textView) {
        AsyncDrawableScheduler.schedule(textView);
    }
}

