/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import ru.noties.markwon.image.ImageSize;
import ru.noties.markwon.image.ImageSizeResolver;

public class ImageSizeResolverDef
extends ImageSizeResolver {
    protected static final String UNIT_PERCENT = "%";
    protected static final String UNIT_EM = "em";

    @Override
    @NonNull
    public Rect resolveImageSize(@Nullable ImageSize imageSize, @NonNull Rect imageBounds, int canvasWidth, float textSize) {
        Rect rect;
        if (imageSize == null) {
            Rect rect2;
            int w = imageBounds.width();
            if (w > canvasWidth) {
                float reduceRatio = (float)w / (float)canvasWidth;
                rect2 = new Rect(0, 0, canvasWidth, (int)((float)imageBounds.height() / reduceRatio + 0.5f));
            } else {
                rect2 = imageBounds;
            }
            return rect2;
        }
        ImageSize.Dimension width = imageSize.width;
        ImageSize.Dimension height = imageSize.height;
        int imageWidth = imageBounds.width();
        int imageHeight = imageBounds.height();
        float ratio = (float)imageWidth / (float)imageHeight;
        if (width != null) {
            int w = UNIT_PERCENT.equals(width.unit) ? (int)((float)canvasWidth * (width.value / 100.0f) + 0.5f) : this.resolveAbsolute(width, imageWidth, textSize);
            int h = height == null || UNIT_PERCENT.equals(height.unit) ? (int)((float)w / ratio + 0.5f) : this.resolveAbsolute(height, imageHeight, textSize);
            rect = new Rect(0, 0, w, h);
        } else if (height != null) {
            if (!UNIT_PERCENT.equals(height.unit)) {
                int h = this.resolveAbsolute(height, imageHeight, textSize);
                int w = (int)((float)h * ratio + 0.5f);
                rect = new Rect(0, 0, w, h);
            } else {
                rect = imageBounds;
            }
        } else {
            rect = imageBounds;
        }
        return rect;
    }

    protected int resolveAbsolute(@NonNull ImageSize.Dimension dimension, int original, float textSize) {
        int out = UNIT_EM.equals(dimension.unit) ? (int)(dimension.value * textSize + 0.5f) : (int)(dimension.value + 0.5f);
        return out;
    }
}

