/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.style.ReplacementSpan;
import ru.noties.markwon.core.MarkwonTheme;
import ru.noties.markwon.image.AsyncDrawable;

public class AsyncDrawableSpan
extends ReplacementSpan {
    public static final int ALIGN_BOTTOM = 0;
    public static final int ALIGN_BASELINE = 1;
    public static final int ALIGN_CENTER = 2;
    private final MarkwonTheme theme;
    private final AsyncDrawable drawable;
    private final int alignment;
    private final boolean replacementTextIsLink;

    public AsyncDrawableSpan(@NonNull MarkwonTheme theme, @NonNull AsyncDrawable drawable, int alignment, boolean replacementTextIsLink) {
        this.theme = theme;
        this.drawable = drawable;
        this.alignment = alignment;
        this.replacementTextIsLink = replacementTextIsLink;
        Rect rect = drawable.getBounds();
        if (rect.isEmpty()) {
            drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        }
    }

    public int getSize(@NonNull Paint paint, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, @Nullable Paint.FontMetricsInt fm) {
        int size;
        if (this.drawable.hasResult()) {
            Rect rect = this.drawable.getBounds();
            if (fm != null) {
                fm.ascent = -rect.bottom;
                fm.descent = 0;
                fm.top = fm.ascent;
                fm.bottom = 0;
            }
            size = rect.right;
        } else {
            if (this.replacementTextIsLink) {
                this.theme.applyLinkStyle(paint);
            }
            size = (int)(paint.measureText(text, start, end) + 0.5f);
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NonNull Canvas canvas, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        this.drawable.initWithKnownDimensions(canvas.getWidth(), paint.getTextSize());
        AsyncDrawable drawable = this.drawable;
        if (drawable.hasResult()) {
            int b = bottom - drawable.getBounds().bottom;
            int save = canvas.save();
            try {
                int translationY = 2 == this.alignment ? b - (bottom - top - drawable.getBounds().height()) / 2 : (1 == this.alignment ? b - paint.getFontMetricsInt().descent : b);
                canvas.translate(x, (float)translationY);
                drawable.draw(canvas);
            }
            finally {
                canvas.restoreToCount(save);
            }
        } else {
            float textY = AsyncDrawableSpan.textCenterY(top, bottom, paint);
            if (this.replacementTextIsLink) {
                this.theme.applyLinkStyle(paint);
            }
            canvas.drawText(text, start, end, x, textY, paint);
        }
    }

    @NonNull
    public AsyncDrawable getDrawable() {
        return this.drawable;
    }

    private static float textCenterY(int top, int bottom, @NonNull Paint paint) {
        return (int)((float)(top + (bottom - top) / 2) - ((paint.descent() + paint.ascent()) / 2.0f + 0.5f));
    }
}

