/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.text.Spanned;
import android.text.style.DynamicDrawableSpan;
import android.view.View;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.noties.markwon.image.AsyncDrawable;
import ru.noties.markwon.image.AsyncDrawableSpan;
import ru.noties.markwon.renderer.R;

public abstract class AsyncDrawableScheduler {
    public static void schedule(final @NonNull TextView textView) {
        List<AsyncDrawable> list = AsyncDrawableScheduler.extract(textView);
        if (list.size() > 0) {
            if (textView.getTag(R.id.markwon_drawables_scheduler) == null) {
                View.OnAttachStateChangeListener listener = new View.OnAttachStateChangeListener(){

                    public void onViewAttachedToWindow(View v) {
                    }

                    public void onViewDetachedFromWindow(View v) {
                        AsyncDrawableScheduler.unschedule(textView);
                        v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                        v.setTag(R.id.markwon_drawables_scheduler, null);
                    }
                };
                textView.addOnAttachStateChangeListener(listener);
                textView.setTag(R.id.markwon_drawables_scheduler, (Object)listener);
            }
            for (AsyncDrawable drawable : list) {
                drawable.setCallback2(new DrawableCallbackImpl(textView, drawable.getBounds()));
            }
        }
    }

    public static void unschedule(@NonNull TextView view) {
        for (AsyncDrawable drawable : AsyncDrawableScheduler.extract(view)) {
            drawable.setCallback2(null);
        }
    }

    private static List<AsyncDrawable> extract(@NonNull TextView view) {
        List<AsyncDrawable> list;
        int length;
        CharSequence cs = view.getText();
        int n = length = cs != null ? cs.length() : 0;
        if (length == 0 || !(cs instanceof Spanned)) {
            list = Collections.EMPTY_LIST;
        } else {
            DynamicDrawableSpan[] dynamicDrawableSpans;
            ArrayList<AsyncDrawable> drawables = new ArrayList<AsyncDrawable>(2);
            Spanned spanned = (Spanned)cs;
            AsyncDrawableSpan[] asyncDrawableSpans = (AsyncDrawableSpan[])spanned.getSpans(0, length, AsyncDrawableSpan.class);
            if (asyncDrawableSpans != null && asyncDrawableSpans.length > 0) {
                for (AsyncDrawableSpan span : asyncDrawableSpans) {
                    drawables.add(span.getDrawable());
                }
            }
            if ((dynamicDrawableSpans = (DynamicDrawableSpan[])spanned.getSpans(0, length, DynamicDrawableSpan.class)) != null && dynamicDrawableSpans.length > 0) {
                for (DynamicDrawableSpan span : dynamicDrawableSpans) {
                    Drawable d = span.getDrawable();
                    if (d == null || !(d instanceof AsyncDrawable)) continue;
                    drawables.add((AsyncDrawable)d);
                }
            }
            list = drawables.size() == 0 ? Collections.EMPTY_LIST : drawables;
        }
        return list;
    }

    private AsyncDrawableScheduler() {
    }

    private static class DrawableCallbackImpl
    implements Drawable.Callback {
        private final TextView view;
        private Rect previousBounds;

        DrawableCallbackImpl(TextView view, Rect initialBounds) {
            this.view = view;
            this.previousBounds = new Rect(initialBounds);
        }

        public void invalidateDrawable(final @NonNull Drawable who) {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.view.post(new Runnable(){

                    @Override
                    public void run() {
                        DrawableCallbackImpl.this.invalidateDrawable(who);
                    }
                });
                return;
            }
            Rect rect = who.getBounds();
            if (!this.previousBounds.equals((Object)rect)) {
                this.view.setText(this.view.getText());
                this.previousBounds = new Rect(rect);
            } else {
                this.view.postInvalidate();
            }
        }

        public void scheduleDrawable(@NonNull Drawable who, @NonNull Runnable what, long when) {
            long delay = when - SystemClock.uptimeMillis();
            this.view.postDelayed(what, delay);
        }

        public void unscheduleDrawable(@NonNull Drawable who, @NonNull Runnable what) {
            this.view.removeCallbacks(what);
        }
    }
}

