/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image;

import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import ru.noties.markwon.image.AsyncDrawable;
import ru.noties.markwon.image.AsyncDrawableLoader;
import ru.noties.markwon.image.ImageItem;
import ru.noties.markwon.image.MediaDecoder;
import ru.noties.markwon.image.SchemeHandler;

class AsyncDrawableLoaderImpl
extends AsyncDrawableLoader {
    private final ExecutorService executorService;
    private final Map<String, SchemeHandler> schemeHandlers;
    private final Map<String, MediaDecoder> mediaDecoders;
    private final MediaDecoder defaultMediaDecoder;
    private final AsyncDrawableLoader.DrawableProvider placeholderDrawableProvider;
    private final AsyncDrawableLoader.DrawableProvider errorDrawableProvider;
    private final Handler handler = new Handler(Looper.getMainLooper());
    private final Map<AsyncDrawable, Future<?>> requests = new HashMap(2);

    AsyncDrawableLoaderImpl(@NonNull AsyncDrawableLoader.Builder builder) {
        this.executorService = builder.executorService;
        this.schemeHandlers = builder.schemeHandlers;
        this.mediaDecoders = builder.mediaDecoders;
        this.defaultMediaDecoder = builder.defaultMediaDecoder;
        this.placeholderDrawableProvider = builder.placeholderDrawableProvider;
        this.errorDrawableProvider = builder.errorDrawableProvider;
    }

    @Override
    public void load(@NonNull AsyncDrawable drawable) {
        Future<?> future = this.requests.get((Object)drawable);
        if (future == null) {
            this.requests.put(drawable, this.execute(drawable));
        }
    }

    @Override
    public void cancel(@NonNull AsyncDrawable drawable) {
        Future<?> future = this.requests.remove((Object)drawable);
        if (future != null) {
            future.cancel(true);
        }
        this.handler.removeCallbacksAndMessages((Object)drawable);
    }

    @Override
    @Nullable
    public Drawable placeholder() {
        return this.placeholderDrawableProvider != null ? this.placeholderDrawableProvider.provide() : null;
    }

    @NonNull
    private Future<?> execute(final @NonNull AsyncDrawable drawable) {
        final String destination = drawable.getDestination();
        return this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Uri uri = Uri.parse((String)destination);
                SchemeHandler schemeHandler = (SchemeHandler)AsyncDrawableLoaderImpl.this.schemeHandlers.get(uri.getScheme());
                ImageItem item = schemeHandler != null ? schemeHandler.handle(destination, uri) : null;
                InputStream inputStream = item != null ? item.inputStream() : null;
                Drawable result = null;
                if (inputStream != null) {
                    try {
                        MediaDecoder mediaDecoder = (MediaDecoder)AsyncDrawableLoaderImpl.this.mediaDecoders.get(item.contentType());
                        if (mediaDecoder == null) {
                            mediaDecoder = AsyncDrawableLoaderImpl.this.defaultMediaDecoder;
                        }
                        if (mediaDecoder != null) {
                            result = mediaDecoder.decode(inputStream);
                        }
                    }
                    finally {
                        try {
                            inputStream.close();
                        }
                        catch (IOException mediaDecoder) {}
                    }
                }
                if (result == null) {
                    result = AsyncDrawableLoaderImpl.this.errorDrawableProvider != null ? AsyncDrawableLoaderImpl.this.errorDrawableProvider.provide() : null;
                }
                final Drawable out = result;
                AsyncDrawableLoaderImpl.this.handler.postAtTime(new Runnable(){

                    @Override
                    public void run() {
                        if (AsyncDrawableLoaderImpl.this.requests.remove((Object)drawable) != null && out != null && drawable.isAttached()) {
                            drawable.setResult(out);
                        }
                    }
                }, (Object)drawable, SystemClock.uptimeMillis());
            }
        });
    }
}

