/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image;

import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ru.noties.markwon.image.AsyncDrawable;
import ru.noties.markwon.image.AsyncDrawableLoaderImpl;
import ru.noties.markwon.image.AsyncDrawableLoaderNoOp;
import ru.noties.markwon.image.MediaDecoder;
import ru.noties.markwon.image.SchemeHandler;

public abstract class AsyncDrawableLoader {
    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static AsyncDrawableLoader noOp() {
        return new AsyncDrawableLoaderNoOp();
    }

    public abstract void load(@NonNull AsyncDrawable var1);

    public abstract void cancel(@NonNull AsyncDrawable var1);

    @Deprecated
    public void load(@NonNull String destination, @NonNull AsyncDrawable drawable) {
        this.load(drawable);
    }

    @Deprecated
    public void cancel(@NonNull String destination) {
        Log.e((String)"MARKWON-IL", (String)("Image loading cancellation must be triggered by AsyncDrawable, please use #cancel(AsyncDrawable) method instead. No op, nothing is cancelled for destination: " + destination));
    }

    @Nullable
    public abstract Drawable placeholder();

    public static class Builder {
        ExecutorService executorService;
        final Map<String, SchemeHandler> schemeHandlers = new HashMap<String, SchemeHandler>(3);
        final Map<String, MediaDecoder> mediaDecoders = new HashMap<String, MediaDecoder>(3);
        MediaDecoder defaultMediaDecoder;
        DrawableProvider placeholderDrawableProvider;
        DrawableProvider errorDrawableProvider;
        AsyncDrawableLoader implementation;

        @NonNull
        public Builder executorService(@NonNull ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @NonNull
        public Builder addSchemeHandler(@NonNull String scheme, @NonNull SchemeHandler schemeHandler) {
            this.schemeHandlers.put(scheme, schemeHandler);
            return this;
        }

        @NonNull
        public Builder addSchemeHandler(@NonNull Collection<String> schemes, @NonNull SchemeHandler schemeHandler) {
            for (String scheme : schemes) {
                this.schemeHandlers.put(scheme, schemeHandler);
            }
            return this;
        }

        @NonNull
        public Builder addMediaDecoder(@NonNull String contentType, @NonNull MediaDecoder mediaDecoder) {
            this.mediaDecoders.put(contentType, mediaDecoder);
            return this;
        }

        @NonNull
        public Builder addMediaDecoder(@NonNull Collection<String> contentTypes, @NonNull MediaDecoder mediaDecoder) {
            for (String contentType : contentTypes) {
                this.mediaDecoders.put(contentType, mediaDecoder);
            }
            return this;
        }

        @NonNull
        public Builder removeSchemeHandler(@NonNull String scheme) {
            this.schemeHandlers.remove(scheme);
            return this;
        }

        @NonNull
        public Builder removeMediaDecoder(@NonNull String contentType) {
            this.mediaDecoders.remove(contentType);
            return this;
        }

        @NonNull
        public Builder defaultMediaDecoder(@Nullable MediaDecoder mediaDecoder) {
            this.defaultMediaDecoder = mediaDecoder;
            return this;
        }

        @NonNull
        public Builder placeholderDrawableProvider(@NonNull DrawableProvider placeholderDrawableProvider) {
            this.placeholderDrawableProvider = placeholderDrawableProvider;
            return this;
        }

        @NonNull
        public Builder errorDrawableProvider(@NonNull DrawableProvider errorDrawableProvider) {
            this.errorDrawableProvider = errorDrawableProvider;
            return this;
        }

        @NonNull
        public Builder implementation(@NonNull AsyncDrawableLoader implementation) {
            this.implementation = implementation;
            return this;
        }

        @NonNull
        public AsyncDrawableLoader build() {
            if (this.implementation != null) {
                return this.implementation;
            }
            if (this.schemeHandlers.size() == 0 || this.mediaDecoders.size() == 0 && this.defaultMediaDecoder == null) {
                return new AsyncDrawableLoaderNoOp();
            }
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool();
            }
            return new AsyncDrawableLoaderImpl(this);
        }
    }

    public static interface DrawableProvider {
        @Nullable
        public Drawable provide();
    }
}

