/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.image;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import ru.noties.markwon.image.AsyncDrawableLoader;
import ru.noties.markwon.image.DrawableUtils;
import ru.noties.markwon.image.ImageSize;
import ru.noties.markwon.image.ImageSizeResolver;

public class AsyncDrawable
extends Drawable {
    private final String destination;
    private final AsyncDrawableLoader loader;
    private final ImageSize imageSize;
    private final ImageSizeResolver imageSizeResolver;
    private Drawable result;
    private Drawable.Callback callback;
    private int canvasWidth;
    private float textSize;
    private boolean waitingForDimensions;

    public AsyncDrawable(@NonNull String destination, @NonNull AsyncDrawableLoader loader, @NonNull ImageSizeResolver imageSizeResolver, @Nullable ImageSize imageSize) {
        this.destination = destination;
        this.loader = loader;
        this.imageSizeResolver = imageSizeResolver;
        this.imageSize = imageSize;
        Drawable placeholder = loader.placeholder();
        if (placeholder != null) {
            this.setPlaceholderResult(placeholder);
        }
    }

    @NonNull
    public String getDestination() {
        return this.destination;
    }

    @Nullable
    public ImageSize getImageSize() {
        return this.imageSize;
    }

    @NonNull
    public ImageSizeResolver getImageSizeResolver() {
        return this.imageSizeResolver;
    }

    public boolean hasKnownDimentions() {
        return this.canvasWidth > 0;
    }

    public int getLastKnownCanvasWidth() {
        return this.canvasWidth;
    }

    public float getLastKnowTextSize() {
        return this.textSize;
    }

    public Drawable getResult() {
        return this.result;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public boolean isAttached() {
        return this.getCallback() != null;
    }

    public void setCallback2(@Nullable Drawable.Callback callback) {
        this.callback = callback;
        super.setCallback(callback);
        if (callback != null) {
            if (this.result != null && this.result.getCallback() == null) {
                this.result.setCallback(callback);
            }
            this.loader.load(this);
        } else {
            if (this.result != null) {
                this.result.setCallback(null);
                if (this.result instanceof Animatable) {
                    ((Animatable)this.result).stop();
                }
            }
            this.loader.cancel(this);
        }
    }

    protected void setPlaceholderResult(@NonNull Drawable placeholder) {
        Rect rect = placeholder.getBounds();
        if (rect.isEmpty()) {
            DrawableUtils.applyIntrinsicBounds(placeholder);
            this.setResult(placeholder);
        } else {
            if (this.result != null) {
                this.result.setCallback(null);
            }
            this.result = placeholder;
            this.result.setCallback(this.callback);
            this.setBounds(rect);
            this.waitingForDimensions = false;
        }
    }

    public void setResult(@NonNull Drawable result) {
        if (this.result != null) {
            this.result.setCallback(null);
        }
        this.result = result;
        this.result.setCallback(this.callback);
        this.initBounds();
    }

    public void clearResult() {
        Drawable result = this.result;
        if (result != null) {
            result.setCallback(null);
            this.result = null;
            this.setBounds(0, 0, 0, 0);
        }
    }

    private void initBounds() {
        if (this.canvasWidth == 0) {
            this.waitingForDimensions = true;
            return;
        }
        this.waitingForDimensions = false;
        Rect bounds = this.resolveBounds();
        this.result.setBounds(bounds);
        this.setBounds(bounds);
        this.invalidateSelf();
    }

    public void initWithKnownDimensions(int width, float textSize) {
        this.canvasWidth = width;
        this.textSize = textSize;
        if (this.waitingForDimensions) {
            this.initBounds();
        }
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.hasResult()) {
            this.result.draw(canvas);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        int opacity = this.hasResult() ? this.result.getOpacity() : -2;
        return opacity;
    }

    public int getIntrinsicWidth() {
        int out = this.hasResult() ? this.result.getIntrinsicWidth() : 0;
        return out;
    }

    public int getIntrinsicHeight() {
        int out = this.hasResult() ? this.result.getIntrinsicHeight() : 0;
        return out;
    }

    @NonNull
    private Rect resolveBounds() {
        return this.imageSizeResolver != null ? this.imageSizeResolver.resolveImageSize(this.imageSize, this.result.getBounds(), this.canvasWidth, this.textSize) : this.result.getBounds();
    }
}

