/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.html;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.noties.markwon.MarkwonVisitor;
import ru.noties.markwon.html.HtmlTag;
import ru.noties.markwon.html.MarkwonHtmlParser;
import ru.noties.markwon.html.MarkwonHtmlRenderer;
import ru.noties.markwon.html.MarkwonHtmlRendererNoOp;
import ru.noties.markwon.html.TagHandler;

class MarkwonHtmlRendererImpl
extends MarkwonHtmlRenderer {
    private final boolean allowNonClosedTags;
    private final Map<String, TagHandler> tagHandlers;

    MarkwonHtmlRendererImpl(boolean allowNonClosedTags, @NonNull Map<String, TagHandler> tagHandlers) {
        this.allowNonClosedTags = allowNonClosedTags;
        this.tagHandlers = tagHandlers;
    }

    @Override
    public void render(final @NonNull MarkwonVisitor visitor, @NonNull MarkwonHtmlParser parser) {
        int end = !this.allowNonClosedTags ? -1 : visitor.length();
        parser.flushInlineTags(end, new MarkwonHtmlParser.FlushAction<HtmlTag.Inline>(){

            @Override
            public void apply(@NonNull List<HtmlTag.Inline> tags) {
                for (HtmlTag.Inline inline : tags) {
                    TagHandler handler;
                    if (!inline.isClosed() || (handler = MarkwonHtmlRendererImpl.this.tagHandler(inline.name())) == null) continue;
                    handler.handle(visitor, MarkwonHtmlRendererImpl.this, inline);
                }
            }
        });
        parser.flushBlockTags(end, new MarkwonHtmlParser.FlushAction<HtmlTag.Block>(){

            @Override
            public void apply(@NonNull List<HtmlTag.Block> tags) {
                for (HtmlTag.Block block : tags) {
                    if (!block.isClosed()) continue;
                    TagHandler handler = MarkwonHtmlRendererImpl.this.tagHandler(block.name());
                    if (handler != null) {
                        handler.handle(visitor, MarkwonHtmlRendererImpl.this, block);
                        continue;
                    }
                    this.apply(block.children());
                }
            }
        });
        parser.reset();
    }

    @Override
    @Nullable
    public TagHandler tagHandler(@NonNull String tagName) {
        return this.tagHandlers.get(tagName);
    }

    static class BuilderImpl
    implements MarkwonHtmlRenderer.Builder {
        private final Map<String, TagHandler> tagHandlers = new HashMap<String, TagHandler>(2);
        private boolean allowNonClosedTags;

        BuilderImpl() {
        }

        @Override
        @NonNull
        public MarkwonHtmlRenderer.Builder allowNonClosedTags(boolean allowNonClosedTags) {
            this.allowNonClosedTags = allowNonClosedTags;
            return this;
        }

        @Override
        @NonNull
        public MarkwonHtmlRenderer.Builder setHandler(@NonNull String tagName, @Nullable TagHandler tagHandler) {
            if (tagHandler == null) {
                this.tagHandlers.remove(tagName);
            } else {
                this.tagHandlers.put(tagName, tagHandler);
            }
            return this;
        }

        @Override
        @NonNull
        public MarkwonHtmlRenderer.Builder setHandler(@NonNull Collection<String> tagNames, @Nullable TagHandler tagHandler) {
            if (tagHandler == null) {
                for (String tagName : tagNames) {
                    this.tagHandlers.remove(tagName);
                }
            } else {
                for (String tagName : tagNames) {
                    this.tagHandlers.put(tagName, tagHandler);
                }
            }
            return this;
        }

        @Override
        @Nullable
        public TagHandler getHandler(@NonNull String tagName) {
            return this.tagHandlers.get(tagName);
        }

        @Override
        @NonNull
        public MarkwonHtmlRenderer build() {
            return this.tagHandlers.size() > 0 ? new MarkwonHtmlRendererImpl(this.allowNonClosedTags, Collections.unmodifiableMap(this.tagHandlers)) : new MarkwonHtmlRendererNoOp();
        }
    }
}

