/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.core.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.style.LeadingMarginSpan;
import ru.noties.markwon.core.MarkwonTheme;
import ru.noties.markwon.core.spans.ObjectsPool;

public class ThematicBreakSpan
implements LeadingMarginSpan {
    private final MarkwonTheme theme;
    private final Rect rect = ObjectsPool.rect();
    private final Paint paint = ObjectsPool.paint();

    public ThematicBreakSpan(@NonNull MarkwonTheme theme) {
        this.theme = theme;
    }

    public int getLeadingMargin(boolean first) {
        return 0;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        int right;
        int left;
        int middle = top + (bottom - top) / 2;
        this.paint.set(p);
        this.theme.applyThematicBreakStyle(this.paint);
        int height = (int)(this.paint.getStrokeWidth() + 0.5f);
        int halfHeight = (int)((float)height / 2.0f + 0.5f);
        if (dir > 0) {
            left = x;
            right = c.getWidth();
        } else {
            left = x - c.getWidth();
            right = x;
        }
        this.rect.set(left, middle - halfHeight, right, middle + halfHeight);
        c.drawRect(this.rect, this.paint);
    }
}

