/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.core.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.LeadingMarginSpan;
import android.widget.TextView;
import ru.noties.markwon.core.MarkwonTheme;
import ru.noties.markwon.core.spans.ObjectsPool;
import ru.noties.markwon.utils.LeadingMarginUtils;

public class OrderedListItemSpan
implements LeadingMarginSpan {
    private final MarkwonTheme theme;
    private final String number;
    private final Paint paint = ObjectsPool.paint();
    private int margin;

    public static void measure(@NonNull TextView textView, @NonNull CharSequence text) {
        if (!(text instanceof Spanned)) {
            return;
        }
        OrderedListItemSpan[] spans = (OrderedListItemSpan[])((Spanned)text).getSpans(0, text.length(), OrderedListItemSpan.class);
        if (spans != null) {
            TextPaint paint = textView.getPaint();
            for (OrderedListItemSpan span : spans) {
                span.margin = (int)(paint.measureText(span.number) + 0.5f);
            }
        }
    }

    public OrderedListItemSpan(@NonNull MarkwonTheme theme, @NonNull String number) {
        this.theme = theme;
        this.number = number;
    }

    public int getLeadingMargin(boolean first) {
        return Math.max(this.margin, this.theme.getBlockMargin());
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        if (!first || !LeadingMarginUtils.selfStart(start, text, this)) {
            return;
        }
        this.paint.set(p);
        this.theme.applyListItemStyle(this.paint);
        int numberWidth = (int)(this.paint.measureText(this.number) + 0.5f);
        int width = this.theme.getBlockMargin();
        if (numberWidth > width) {
            width = numberWidth;
            this.margin = numberWidth;
        } else {
            this.margin = 0;
        }
        int left = dir > 0 ? x + width * dir - numberWidth : x + width * dir + (width - numberWidth);
        c.drawText(this.number, (float)left, (float)baseline, this.paint);
    }
}

