/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;

public class SpannableBuilder
implements Appendable,
CharSequence {
    private final StringBuilder builder;
    private final Deque<Span> spans = new ArrayDeque<Span>(8);

    public static void setSpans(@NonNull SpannableBuilder builder, @Nullable Object spans, int start, int end) {
        if (spans != null) {
            if (!SpannableBuilder.isPositionValid(builder.length(), start, end)) {
                return;
            }
            SpannableBuilder.setSpansInternal(builder, spans, start, end);
        }
    }

    @VisibleForTesting
    static boolean isPositionValid(int length, int start, int end) {
        return end > start && start >= 0 && end <= length;
    }

    public SpannableBuilder() {
        this("");
    }

    public SpannableBuilder(@NonNull CharSequence cs) {
        this.builder = new StringBuilder(cs);
        this.copySpans(0, cs);
    }

    @NonNull
    public SpannableBuilder append(@NonNull String text) {
        this.builder.append(text);
        return this;
    }

    @Override
    @NonNull
    public SpannableBuilder append(char c) {
        this.builder.append(c);
        return this;
    }

    @Override
    @NonNull
    public SpannableBuilder append(@NonNull CharSequence cs) {
        this.copySpans(this.length(), cs);
        this.builder.append(cs);
        return this;
    }

    @Override
    @NonNull
    public SpannableBuilder append(CharSequence csq, int start, int end) {
        CharSequence cs = csq.subSequence(start, end);
        this.copySpans(this.length(), cs);
        this.builder.append(cs);
        return this;
    }

    @NonNull
    public SpannableBuilder append(@NonNull CharSequence cs, @NonNull Object span) {
        int length = this.length();
        this.append(cs);
        this.setSpan(span, length);
        return this;
    }

    @NonNull
    public SpannableBuilder append(@NonNull CharSequence cs, @NonNull Object span, int flags) {
        int length = this.length();
        this.append(cs);
        this.setSpan(span, length, this.length(), flags);
        return this;
    }

    @NonNull
    public SpannableBuilder setSpan(@NonNull Object span, int start) {
        return this.setSpan(span, start, this.length());
    }

    @NonNull
    public SpannableBuilder setSpan(@NonNull Object span, int start, int end) {
        return this.setSpan(span, start, end, 33);
    }

    @NonNull
    public SpannableBuilder setSpan(@NonNull Object span, int start, int end, int flags) {
        this.spans.push(new Span(span, start, end, flags));
        return this;
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public char charAt(int index) {
        return this.builder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        CharSequence out;
        List<Span> spans = this.getSpans(start, end);
        if (spans.isEmpty()) {
            out = this.builder.subSequence(start, end);
        } else {
            SpannableStringBuilder builder = new SpannableStringBuilder(this.builder.subSequence(start, end));
            int length = builder.length();
            for (Span span : spans) {
                int s = Math.max(0, span.start - start);
                int e = Math.max(length, s + (span.end - span.start));
                builder.setSpan(span.what, s, e, span.flags);
            }
            out = builder;
        }
        return out;
    }

    @NonNull
    public List<Span> getSpans(int start, int end) {
        int length = this.length();
        if (!SpannableBuilder.isPositionValid(length, start, end)) {
            return Collections.emptyList();
        }
        if (start == 0 && length == end) {
            ArrayList<Span> list = new ArrayList<Span>(this.spans);
            Collections.reverse(list);
            return Collections.unmodifiableList(list);
        }
        ArrayList<Span> list = new ArrayList<Span>(0);
        Iterator<Span> iterator = this.spans.descendingIterator();
        while (iterator.hasNext()) {
            Span span = iterator.next();
            if (!(span.start >= start && span.start < end || span.end <= end && span.end > start) && (span.start >= start || span.end <= end)) continue;
            list.add(span);
        }
        return Collections.unmodifiableList(list);
    }

    public char lastChar() {
        return this.builder.charAt(this.length() - 1);
    }

    @NonNull
    public CharSequence removeFromEnd(int start) {
        Span span;
        int end = this.length();
        SpannableStringBuilderReversed impl = new SpannableStringBuilderReversed(this.builder.subSequence(start, end));
        Iterator<Span> iterator = this.spans.iterator();
        while (iterator.hasNext() && (span = iterator.next()) != null) {
            if (span.start < start || span.end > end) continue;
            impl.setSpan(span.what, span.start - start, span.end - start, 33);
            iterator.remove();
        }
        this.builder.replace(start, end, "");
        return impl;
    }

    @Override
    @NonNull
    public String toString() {
        return this.builder.toString();
    }

    @NonNull
    public CharSequence text() {
        return this.spannableStringBuilder();
    }

    @NonNull
    public SpannableStringBuilder spannableStringBuilder() {
        SpannableStringBuilderReversed reversed = new SpannableStringBuilderReversed(this.builder);
        for (Span span : this.spans) {
            reversed.setSpan(span.what, span.start, span.end, span.flags);
        }
        return reversed;
    }

    public void clear() {
        this.builder.setLength(0);
        this.spans.clear();
    }

    private void copySpans(int index, @Nullable CharSequence cs) {
        block5: {
            int length;
            if (!(cs instanceof Spanned)) break block5;
            Spanned spanned = (Spanned)cs;
            boolean reversed = spanned instanceof SpannableStringBuilderReversed;
            Object[] spans = spanned.getSpans(0, spanned.length(), Object.class);
            int n = length = spans != null ? spans.length : 0;
            if (length > 0) {
                if (reversed) {
                    for (int i = length - 1; i >= 0; --i) {
                        Object o = spans[i];
                        this.setSpan(o, index + spanned.getSpanStart(o), index + spanned.getSpanEnd(o), spanned.getSpanFlags(o));
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        Object o = spans[i];
                        this.setSpan(o, index + spanned.getSpanStart(o), index + spanned.getSpanEnd(o), spanned.getSpanFlags(o));
                    }
                }
            }
        }
    }

    private static void setSpansInternal(@NonNull SpannableBuilder builder, @Nullable Object spans, int start, int end) {
        if (spans != null) {
            if (spans.getClass().isArray()) {
                for (Object o : (Object[])spans) {
                    SpannableBuilder.setSpansInternal(builder, o, start, end);
                }
            } else {
                builder.setSpan(spans, start, end, 33);
            }
        }
    }

    static class SpannableStringBuilderReversed
    extends SpannableStringBuilder {
        SpannableStringBuilderReversed(CharSequence text) {
            super(text);
        }
    }

    public static class Span {
        public final Object what;
        public int start;
        public int end;
        public final int flags;

        Span(@NonNull Object what, int start, int end, int flags) {
            this.what = what;
            this.start = start;
            this.end = end;
            this.flags = flags;
        }
    }
}

