/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;
import ru.noties.markwon.MarkwonConfiguration;
import ru.noties.markwon.MarkwonVisitor;
import ru.noties.markwon.RenderProps;
import ru.noties.markwon.SpanFactory;
import ru.noties.markwon.SpannableBuilder;

class MarkwonVisitorImpl
implements MarkwonVisitor {
    private final MarkwonConfiguration configuration;
    private final RenderProps renderProps;
    private final SpannableBuilder builder;
    private final Map<Class<? extends Node>, MarkwonVisitor.NodeVisitor<? extends Node>> nodes;

    MarkwonVisitorImpl(@NonNull MarkwonConfiguration configuration, @NonNull RenderProps renderProps, @NonNull SpannableBuilder builder, @NonNull Map<Class<? extends Node>, MarkwonVisitor.NodeVisitor<? extends Node>> nodes) {
        this.configuration = configuration;
        this.renderProps = renderProps;
        this.builder = builder;
        this.nodes = nodes;
    }

    public void visit(BlockQuote blockQuote) {
        this.visit((Node)blockQuote);
    }

    public void visit(BulletList bulletList) {
        this.visit((Node)bulletList);
    }

    public void visit(Code code) {
        this.visit((Node)code);
    }

    public void visit(Document document) {
        this.visit((Node)document);
    }

    public void visit(Emphasis emphasis) {
        this.visit((Node)emphasis);
    }

    public void visit(FencedCodeBlock fencedCodeBlock) {
        this.visit((Node)fencedCodeBlock);
    }

    public void visit(HardLineBreak hardLineBreak) {
        this.visit((Node)hardLineBreak);
    }

    public void visit(Heading heading) {
        this.visit((Node)heading);
    }

    public void visit(ThematicBreak thematicBreak) {
        this.visit((Node)thematicBreak);
    }

    public void visit(HtmlInline htmlInline) {
        this.visit((Node)htmlInline);
    }

    public void visit(HtmlBlock htmlBlock) {
        this.visit((Node)htmlBlock);
    }

    public void visit(Image image) {
        this.visit((Node)image);
    }

    public void visit(IndentedCodeBlock indentedCodeBlock) {
        this.visit((Node)indentedCodeBlock);
    }

    public void visit(Link link) {
        this.visit((Node)link);
    }

    public void visit(ListItem listItem) {
        this.visit((Node)listItem);
    }

    public void visit(OrderedList orderedList) {
        this.visit((Node)orderedList);
    }

    public void visit(Paragraph paragraph) {
        this.visit((Node)paragraph);
    }

    public void visit(SoftLineBreak softLineBreak) {
        this.visit((Node)softLineBreak);
    }

    public void visit(StrongEmphasis strongEmphasis) {
        this.visit((Node)strongEmphasis);
    }

    public void visit(Text text) {
        this.visit((Node)text);
    }

    public void visit(CustomBlock customBlock) {
        this.visit((Node)customBlock);
    }

    public void visit(CustomNode customNode) {
        this.visit((Node)customNode);
    }

    private void visit(@NonNull Node node) {
        MarkwonVisitor.NodeVisitor<? extends Node> nodeVisitor = this.nodes.get(node.getClass());
        if (nodeVisitor != null) {
            nodeVisitor.visit(this, (Node)node);
        } else {
            this.visitChildren(node);
        }
    }

    @Override
    @NonNull
    public MarkwonConfiguration configuration() {
        return this.configuration;
    }

    @Override
    @NonNull
    public RenderProps renderProps() {
        return this.renderProps;
    }

    @Override
    @NonNull
    public SpannableBuilder builder() {
        return this.builder;
    }

    @Override
    public void visitChildren(@NonNull Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            node.accept((Visitor)this);
            node = next;
        }
    }

    @Override
    public boolean hasNext(@NonNull Node node) {
        return node.getNext() != null;
    }

    @Override
    public void ensureNewLine() {
        if (this.builder.length() > 0 && '\n' != this.builder.lastChar()) {
            this.builder.append('\n');
        }
    }

    @Override
    public void forceNewLine() {
        this.builder.append('\n');
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public void setSpans(int start, @Nullable Object spans) {
        SpannableBuilder.setSpans(this.builder, spans, start, this.builder.length());
    }

    @Override
    public void clear() {
        this.renderProps.clearAll();
        this.builder.clear();
    }

    @Override
    public <N extends Node> void setSpansForNode(@NonNull N node, int start) {
        this.setSpansForNode(node.getClass(), start);
    }

    @Override
    public <N extends Node> void setSpansForNode(@NonNull Class<N> node, int start) {
        this.setSpans(start, this.configuration.spansFactory().require(node).getSpans(this.configuration, this.renderProps));
    }

    @Override
    public <N extends Node> void setSpansForNodeOptional(@NonNull N node, int start) {
        this.setSpansForNodeOptional(node.getClass(), start);
    }

    @Override
    public <N extends Node> void setSpansForNodeOptional(@NonNull Class<N> node, int start) {
        SpanFactory factory = this.configuration.spansFactory().get(node);
        if (factory != null) {
            this.setSpans(start, factory.getSpans(this.configuration, this.renderProps));
        }
    }

    static class BuilderImpl
    implements MarkwonVisitor.Builder {
        private final Map<Class<? extends Node>, MarkwonVisitor.NodeVisitor<? extends Node>> nodes = new HashMap<Class<? extends Node>, MarkwonVisitor.NodeVisitor<? extends Node>>();

        BuilderImpl() {
        }

        @Override
        @NonNull
        public <N extends Node> MarkwonVisitor.Builder on(@NonNull Class<N> node, @Nullable MarkwonVisitor.NodeVisitor<? super N> nodeVisitor) {
            if (nodeVisitor == null) {
                this.nodes.remove(node);
            } else {
                this.nodes.put(node, nodeVisitor);
            }
            return this;
        }

        @Override
        @NonNull
        public MarkwonVisitor build(@NonNull MarkwonConfiguration configuration, @NonNull RenderProps renderProps) {
            return new MarkwonVisitorImpl(configuration, renderProps, new SpannableBuilder(), Collections.unmodifiableMap(this.nodes));
        }
    }
}

