/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.commonmark.node.Node;
import ru.noties.markwon.MarkwonConfiguration;
import ru.noties.markwon.MarkwonSpansFactory;
import ru.noties.markwon.RenderProps;
import ru.noties.markwon.SpanFactory;

class MarkwonSpansFactoryImpl
implements MarkwonSpansFactory {
    private final Map<Class<? extends Node>, SpanFactory> factories;

    MarkwonSpansFactoryImpl(@NonNull Map<Class<? extends Node>, SpanFactory> factories) {
        this.factories = factories;
    }

    @Override
    @Nullable
    public <N extends Node> SpanFactory get(@NonNull Class<N> node) {
        return this.factories.get(node);
    }

    @Override
    @NonNull
    public <N extends Node> SpanFactory require(@NonNull Class<N> node) {
        SpanFactory f = this.get(node);
        if (f == null) {
            throw new NullPointerException(node.getName());
        }
        return f;
    }

    static class CompositeSpanFactory
    implements SpanFactory {
        final List<SpanFactory> factories = new ArrayList<SpanFactory>(3);

        CompositeSpanFactory(@NonNull SpanFactory first, @NonNull SpanFactory second) {
            this.factories.add(first);
            this.factories.add(second);
        }

        @Override
        @Nullable
        public Object getSpans(@NonNull MarkwonConfiguration configuration, @NonNull RenderProps props) {
            int length = this.factories.size();
            Object[] out = new Object[length];
            for (int i = 0; i < length; ++i) {
                out[i] = this.factories.get(i).getSpans(configuration, props);
            }
            return out;
        }
    }

    static class BuilderImpl
    implements MarkwonSpansFactory.Builder {
        private final Map<Class<? extends Node>, SpanFactory> factories = new HashMap<Class<? extends Node>, SpanFactory>(3);

        BuilderImpl() {
        }

        @Override
        @NonNull
        public <N extends Node> MarkwonSpansFactory.Builder setFactory(@NonNull Class<N> node, @Nullable SpanFactory factory) {
            if (factory == null) {
                this.factories.remove(node);
            } else {
                this.factories.put(node, factory);
            }
            return this;
        }

        @Override
        @NonNull
        public <N extends Node> MarkwonSpansFactory.Builder addFactory(@NonNull Class<N> node, @NonNull SpanFactory factory) {
            SpanFactory existing = this.factories.get(node);
            if (existing == null) {
                this.factories.put(node, factory);
            } else if (existing instanceof CompositeSpanFactory) {
                ((CompositeSpanFactory)existing).factories.add(factory);
            } else {
                CompositeSpanFactory compositeSpanFactory = new CompositeSpanFactory(existing, factory);
                this.factories.put(node, compositeSpanFactory);
            }
            return this;
        }

        @Override
        @Nullable
        public <N extends Node> SpanFactory getFactory(@NonNull Class<N> node) {
            return this.factories.get(node);
        }

        @Override
        @NonNull
        public <N extends Node> SpanFactory requireFactory(@NonNull Class<N> node) {
            SpanFactory factory = this.getFactory(node);
            if (factory == null) {
                throw new NullPointerException(node.getName());
            }
            return factory;
        }

        @Override
        @NonNull
        public MarkwonSpansFactory build() {
            return new MarkwonSpansFactoryImpl(Collections.unmodifiableMap(this.factories));
        }
    }
}

