/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.content.Context;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import java.util.HashMap;
import java.util.Map;
import org.commonmark.node.Node;
import ru.noties.markwon.Markwon;
import ru.noties.markwon.MarkwonReducer;

public abstract class MarkwonNodeRenderer {
    @NonNull
    public static Builder builder(@NonNull ViewProvider<Node> defaultViewProvider) {
        return new Builder(defaultViewProvider);
    }

    @NonNull
    public static Builder builder(@LayoutRes int defaultViewProviderLayoutResId, @IdRes int defaultViewProviderTextViewId) {
        return new Builder(new SimpleTextViewProvider(defaultViewProviderLayoutResId, defaultViewProviderTextViewId));
    }

    public abstract void render(@NonNull ViewGroup var1, @NonNull Markwon var2, @NonNull String var3);

    public abstract void render(@NonNull ViewGroup var1, @NonNull Markwon var2, @NonNull Node var3);

    static class Impl
    extends MarkwonNodeRenderer {
        private final MarkwonReducer reducer;
        private final Map<Class<? extends Node>, ViewProvider<Node>> viewProviders;
        private final ViewProvider<Node> defaultViewProvider;
        private LayoutInflater inflater;

        Impl(@NonNull Builder builder) {
            this.reducer = builder.reducer;
            this.viewProviders = builder.viewProviders;
            this.defaultViewProvider = builder.defaultViewProvider;
            this.inflater = builder.inflater;
        }

        @Override
        public void render(@NonNull ViewGroup group, @NonNull Markwon markwon, @NonNull String markdown) {
            this.render(group, markwon, markwon.parse(markdown));
        }

        @Override
        public void render(@NonNull ViewGroup group, @NonNull Markwon markwon, @NonNull Node root) {
            LayoutInflater inflater = this.ensureLayoutInflater(group.getContext());
            for (Node node : this.reducer.reduce(root)) {
                ViewProvider<Node> viewProvider = this.viewProvider(node);
                group.addView(viewProvider.provide(inflater, group, markwon, node));
            }
        }

        @NonNull
        private LayoutInflater ensureLayoutInflater(@NonNull Context context) {
            LayoutInflater inflater = this.inflater;
            if (inflater == null) {
                inflater = this.inflater = LayoutInflater.from((Context)context);
            }
            return inflater;
        }

        @NonNull
        private ViewProvider<Node> viewProvider(@NonNull Node node) {
            ViewProvider<Node> provider = this.viewProviders.get(node.getClass());
            if (provider != null) {
                return provider;
            }
            return this.defaultViewProvider;
        }
    }

    public static class SimpleTextViewProvider
    implements ViewProvider<Node> {
        private final int layoutResId;
        private final int textViewId;

        public SimpleTextViewProvider(@LayoutRes int layoutResId, @IdRes int textViewId) {
            this.layoutResId = layoutResId;
            this.textViewId = textViewId;
        }

        @Override
        @NonNull
        public View provide(@NonNull LayoutInflater inflater, @NonNull ViewGroup group, @NonNull Markwon markwon, @NonNull Node node) {
            View view = inflater.inflate(this.layoutResId, group, false);
            TextView textView = (TextView)view.findViewById(this.textViewId);
            markwon.setParsedMarkdown(textView, markwon.render(node));
            return view;
        }
    }

    public static class Builder {
        private final ViewProvider<Node> defaultViewProvider;
        private MarkwonReducer reducer;
        private Map<Class<? extends Node>, ViewProvider<Node>> viewProviders;
        private LayoutInflater inflater;

        public Builder(@NonNull ViewProvider<Node> defaultViewProvider) {
            this.defaultViewProvider = defaultViewProvider;
            this.viewProviders = new HashMap<Class<? extends Node>, ViewProvider<Node>>(3);
        }

        @NonNull
        public Builder reducer(@NonNull MarkwonReducer reducer) {
            this.reducer = reducer;
            return this;
        }

        @NonNull
        public <N extends Node> Builder viewProvider(@NonNull Class<N> type, @NonNull ViewProvider<? super N> viewProvider) {
            this.viewProviders.put(type, viewProvider);
            return this;
        }

        @NonNull
        public Builder inflater(@NonNull LayoutInflater inflater) {
            this.inflater = inflater;
            return this;
        }

        @NonNull
        public MarkwonNodeRenderer build() {
            if (this.reducer == null) {
                this.reducer = MarkwonReducer.directChildren();
            }
            return new Impl(this);
        }
    }

    public static interface ViewProvider<N extends Node> {
        @NonNull
        public View provide(@NonNull LayoutInflater var1, @NonNull ViewGroup var2, @NonNull Markwon var3, @NonNull N var4);
    }
}

