/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.widget.TextView;
import java.util.List;
import org.commonmark.node.Node;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import ru.noties.markwon.Markwon;
import ru.noties.markwon.MarkwonPlugin;
import ru.noties.markwon.MarkwonVisitor;

class MarkwonImpl
extends Markwon {
    private final TextView.BufferType bufferType;
    private final Parser parser;
    private final MarkwonVisitor visitor;
    private final List<MarkwonPlugin> plugins;

    MarkwonImpl(@NonNull TextView.BufferType bufferType, @NonNull Parser parser, @NonNull MarkwonVisitor visitor, @NonNull List<MarkwonPlugin> plugins) {
        this.bufferType = bufferType;
        this.parser = parser;
        this.visitor = visitor;
        this.plugins = plugins;
    }

    @Override
    @NonNull
    public Node parse(@NonNull String input) {
        for (MarkwonPlugin plugin : this.plugins) {
            input = plugin.processMarkdown(input);
        }
        return this.parser.parse(input);
    }

    @Override
    @NonNull
    public Spanned render(@NonNull Node node) {
        for (MarkwonPlugin plugin : this.plugins) {
            plugin.beforeRender(node);
        }
        node.accept((Visitor)this.visitor);
        for (MarkwonPlugin plugin : this.plugins) {
            plugin.afterRender(node, this.visitor);
        }
        SpannableStringBuilder spanned = this.visitor.builder().spannableStringBuilder();
        this.visitor.clear();
        return spanned;
    }

    @Override
    @NonNull
    public Spanned toMarkdown(@NonNull String input) {
        return this.render(this.parse(input));
    }

    @Override
    public void setMarkdown(@NonNull TextView textView, @NonNull String markdown) {
        this.setParsedMarkdown(textView, this.toMarkdown(markdown));
    }

    @Override
    public void setParsedMarkdown(@NonNull TextView textView, @NonNull Spanned markdown) {
        for (MarkwonPlugin plugin : this.plugins) {
            plugin.beforeSetText(textView, markdown);
        }
        textView.setText((CharSequence)markdown, this.bufferType);
        for (MarkwonPlugin plugin : this.plugins) {
            plugin.afterSetText(textView);
        }
    }

    @Override
    public boolean hasPlugin(@NonNull Class<? extends MarkwonPlugin> type) {
        return this.getPlugin(type) != null;
    }

    @Override
    @Nullable
    public <P extends MarkwonPlugin> P getPlugin(@NonNull Class<P> type) {
        MarkwonPlugin out = null;
        for (MarkwonPlugin plugin : this.plugins) {
            if (!type.isAssignableFrom(plugin.getClass())) continue;
            out = plugin;
        }
        return (P)out;
    }
}

