/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.support.annotation.NonNull;
import ru.noties.markwon.LinkResolverDef;
import ru.noties.markwon.MarkwonSpansFactory;
import ru.noties.markwon.core.MarkwonTheme;
import ru.noties.markwon.core.spans.LinkSpan;
import ru.noties.markwon.html.MarkwonHtmlParser;
import ru.noties.markwon.html.MarkwonHtmlRenderer;
import ru.noties.markwon.image.AsyncDrawableLoader;
import ru.noties.markwon.image.ImageSizeResolver;
import ru.noties.markwon.image.ImageSizeResolverDef;
import ru.noties.markwon.syntax.SyntaxHighlight;
import ru.noties.markwon.syntax.SyntaxHighlightNoOp;
import ru.noties.markwon.urlprocessor.UrlProcessor;
import ru.noties.markwon.urlprocessor.UrlProcessorNoOp;

public class MarkwonConfiguration {
    private final MarkwonTheme theme;
    private final AsyncDrawableLoader asyncDrawableLoader;
    private final SyntaxHighlight syntaxHighlight;
    private final LinkSpan.Resolver linkResolver;
    private final UrlProcessor urlProcessor;
    private final ImageSizeResolver imageSizeResolver;
    private final MarkwonHtmlParser htmlParser;
    private final MarkwonHtmlRenderer htmlRenderer;
    private final MarkwonSpansFactory spansFactory;

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    private MarkwonConfiguration(@NonNull Builder builder) {
        this.theme = builder.theme;
        this.asyncDrawableLoader = builder.asyncDrawableLoader;
        this.syntaxHighlight = builder.syntaxHighlight;
        this.linkResolver = builder.linkResolver;
        this.urlProcessor = builder.urlProcessor;
        this.imageSizeResolver = builder.imageSizeResolver;
        this.spansFactory = builder.spansFactory;
        this.htmlParser = builder.htmlParser;
        this.htmlRenderer = builder.htmlRenderer;
    }

    @NonNull
    public MarkwonTheme theme() {
        return this.theme;
    }

    @NonNull
    public AsyncDrawableLoader asyncDrawableLoader() {
        return this.asyncDrawableLoader;
    }

    @NonNull
    public SyntaxHighlight syntaxHighlight() {
        return this.syntaxHighlight;
    }

    @NonNull
    public LinkSpan.Resolver linkResolver() {
        return this.linkResolver;
    }

    @NonNull
    public UrlProcessor urlProcessor() {
        return this.urlProcessor;
    }

    @NonNull
    public ImageSizeResolver imageSizeResolver() {
        return this.imageSizeResolver;
    }

    @NonNull
    public MarkwonHtmlParser htmlParser() {
        return this.htmlParser;
    }

    @NonNull
    public MarkwonHtmlRenderer htmlRenderer() {
        return this.htmlRenderer;
    }

    @NonNull
    public MarkwonSpansFactory spansFactory() {
        return this.spansFactory;
    }

    public static class Builder {
        private MarkwonTheme theme;
        private AsyncDrawableLoader asyncDrawableLoader;
        private SyntaxHighlight syntaxHighlight;
        private LinkSpan.Resolver linkResolver;
        private UrlProcessor urlProcessor;
        private ImageSizeResolver imageSizeResolver;
        private MarkwonHtmlParser htmlParser;
        private MarkwonHtmlRenderer htmlRenderer;
        private MarkwonSpansFactory spansFactory;

        Builder() {
        }

        @NonNull
        public Builder syntaxHighlight(@NonNull SyntaxHighlight syntaxHighlight) {
            this.syntaxHighlight = syntaxHighlight;
            return this;
        }

        @NonNull
        public Builder linkResolver(@NonNull LinkSpan.Resolver linkResolver) {
            this.linkResolver = linkResolver;
            return this;
        }

        @NonNull
        public Builder urlProcessor(@NonNull UrlProcessor urlProcessor) {
            this.urlProcessor = urlProcessor;
            return this;
        }

        @NonNull
        public Builder htmlParser(@NonNull MarkwonHtmlParser htmlParser) {
            this.htmlParser = htmlParser;
            return this;
        }

        @NonNull
        public Builder imageSizeResolver(@NonNull ImageSizeResolver imageSizeResolver) {
            this.imageSizeResolver = imageSizeResolver;
            return this;
        }

        @NonNull
        public MarkwonConfiguration build(@NonNull MarkwonTheme theme, @NonNull AsyncDrawableLoader asyncDrawableLoader, @NonNull MarkwonHtmlRenderer htmlRenderer, @NonNull MarkwonSpansFactory spansFactory) {
            this.theme = theme;
            this.asyncDrawableLoader = asyncDrawableLoader;
            this.htmlRenderer = htmlRenderer;
            this.spansFactory = spansFactory;
            if (this.syntaxHighlight == null) {
                this.syntaxHighlight = new SyntaxHighlightNoOp();
            }
            if (this.linkResolver == null) {
                this.linkResolver = new LinkResolverDef();
            }
            if (this.urlProcessor == null) {
                this.urlProcessor = new UrlProcessorNoOp();
            }
            if (this.imageSizeResolver == null) {
                this.imageSizeResolver = new ImageSizeResolverDef();
            }
            if (this.htmlParser == null) {
                this.htmlParser = MarkwonHtmlParser.noOp();
            }
            return new MarkwonConfiguration(this);
        }
    }
}

