/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.commonmark.parser.Parser;
import ru.noties.markwon.Markwon;
import ru.noties.markwon.MarkwonConfiguration;
import ru.noties.markwon.MarkwonImpl;
import ru.noties.markwon.MarkwonPlugin;
import ru.noties.markwon.MarkwonSpansFactoryImpl;
import ru.noties.markwon.MarkwonVisitorImpl;
import ru.noties.markwon.RenderPropsImpl;
import ru.noties.markwon.core.CorePlugin;
import ru.noties.markwon.core.MarkwonTheme;
import ru.noties.markwon.html.MarkwonHtmlRenderer;
import ru.noties.markwon.image.AsyncDrawableLoader;
import ru.noties.markwon.priority.PriorityProcessor;

class MarkwonBuilderImpl
implements Markwon.Builder {
    private final Context context;
    private final List<MarkwonPlugin> plugins = new ArrayList<MarkwonPlugin>(3);
    private TextView.BufferType bufferType = TextView.BufferType.SPANNABLE;
    private PriorityProcessor priorityProcessor;

    MarkwonBuilderImpl(@NonNull Context context) {
        this.context = context;
    }

    @Override
    @NonNull
    public Markwon.Builder bufferType(@NonNull TextView.BufferType bufferType) {
        this.bufferType = bufferType;
        return this;
    }

    @Override
    @NonNull
    public Markwon.Builder usePlugin(@NonNull MarkwonPlugin plugin) {
        this.plugins.add(plugin);
        return this;
    }

    @Override
    @NonNull
    public Markwon.Builder usePlugins(@NonNull Iterable<? extends MarkwonPlugin> plugins) {
        for (MarkwonPlugin markwonPlugin : plugins) {
            if (markwonPlugin == null) {
                throw new NullPointerException();
            }
            this.plugins.add(markwonPlugin);
        }
        return this;
    }

    @NonNull
    public MarkwonBuilderImpl priorityProcessor(@NonNull PriorityProcessor priorityProcessor) {
        this.priorityProcessor = priorityProcessor;
        return this;
    }

    @Override
    @NonNull
    public Markwon build() {
        if (this.plugins.isEmpty()) {
            throw new IllegalStateException("No plugins were added to this builder. Use #usePlugin method to add them");
        }
        PriorityProcessor priorityProcessor = this.priorityProcessor;
        if (priorityProcessor == null) {
            priorityProcessor = this.priorityProcessor = PriorityProcessor.create();
        }
        List<MarkwonPlugin> plugins = MarkwonBuilderImpl.preparePlugins(priorityProcessor, this.plugins);
        Parser.Builder parserBuilder = new Parser.Builder();
        MarkwonTheme.Builder themeBuilder = MarkwonTheme.builderWithDefaults(this.context);
        AsyncDrawableLoader.Builder asyncDrawableLoaderBuilder = new AsyncDrawableLoader.Builder();
        MarkwonConfiguration.Builder configurationBuilder = new MarkwonConfiguration.Builder();
        MarkwonVisitorImpl.BuilderImpl visitorBuilder = new MarkwonVisitorImpl.BuilderImpl();
        MarkwonSpansFactoryImpl.BuilderImpl spanFactoryBuilder = new MarkwonSpansFactoryImpl.BuilderImpl();
        MarkwonHtmlRenderer.Builder htmlRendererBuilder = MarkwonHtmlRenderer.builder();
        for (MarkwonPlugin plugin : plugins) {
            plugin.configureParser(parserBuilder);
            plugin.configureTheme(themeBuilder);
            plugin.configureImages(asyncDrawableLoaderBuilder);
            plugin.configureConfiguration(configurationBuilder);
            plugin.configureVisitor(visitorBuilder);
            plugin.configureSpansFactory(spanFactoryBuilder);
            plugin.configureHtmlRenderer(htmlRendererBuilder);
        }
        MarkwonConfiguration configuration = configurationBuilder.build(themeBuilder.build(), asyncDrawableLoaderBuilder.build(), htmlRendererBuilder.build(), spanFactoryBuilder.build());
        RenderPropsImpl renderProps = new RenderPropsImpl();
        return new MarkwonImpl(this.bufferType, parserBuilder.build(), visitorBuilder.build(configuration, renderProps), Collections.unmodifiableList(plugins));
    }

    @VisibleForTesting
    @NonNull
    static List<MarkwonPlugin> preparePlugins(@NonNull PriorityProcessor priorityProcessor, @NonNull List<MarkwonPlugin> plugins) {
        List<MarkwonPlugin> out = MarkwonBuilderImpl.ensureImplicitCoreIfHasDependents(plugins);
        return priorityProcessor.process(out);
    }

    @VisibleForTesting
    @NonNull
    static List<MarkwonPlugin> ensureImplicitCoreIfHasDependents(@NonNull List<MarkwonPlugin> plugins) {
        boolean hasCore = false;
        boolean hasCoreDependents = false;
        for (MarkwonPlugin plugin : plugins) {
            if (CorePlugin.class.isAssignableFrom(plugin.getClass())) {
                hasCore = true;
                break;
            }
            if (hasCoreDependents || !plugin.priority().after().contains(CorePlugin.class)) continue;
            hasCoreDependents = true;
        }
        if (hasCoreDependents && !hasCore) {
            ArrayList<MarkwonPlugin> out = new ArrayList<MarkwonPlugin>(plugins.size() + 1);
            out.add(CorePlugin.create());
            out.addAll(plugins);
            return out;
        }
        return plugins;
    }
}

