/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.tasklist;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.node.Block;
import org.commonmark.node.Node;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import ru.noties.markwon.tasklist.TaskListBlock;
import ru.noties.markwon.tasklist.TaskListItem;

class TaskListBlockParser
extends AbstractBlockParser {
    private static final Pattern PATTERN = Pattern.compile("\\s*-\\s+\\[(x|X|\\s)\\]\\s+(.*)");
    private final TaskListBlock block = new TaskListBlock();
    private final List<Item> items = new ArrayList<Item>(3);
    private int indent = 0;

    TaskListBlockParser(@NonNull String startLine, int startIndent) {
        this.items.add(new Item(startLine, startIndent));
        this.indent = startIndent;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState parserState) {
        String line = TaskListBlockParser.line(parserState);
        int currentIndent = parserState.getIndent();
        if (currentIndent > this.indent) {
            this.indent += 2;
        } else if (currentIndent < this.indent && this.indent > 1) {
            this.indent -= 2;
        }
        BlockContinue blockContinue = line != null && line.length() > 0 && PATTERN.matcher(line).matches() ? BlockContinue.atIndex((int)parserState.getIndex()) : BlockContinue.none();
        return blockContinue;
    }

    public void addLine(CharSequence line) {
        if (TaskListBlockParser.length(line) > 0) {
            this.items.add(new Item(line.toString(), this.indent));
        }
    }

    public void parseInlines(InlineParser inlineParser) {
        for (Item item : this.items) {
            Matcher matcher = PATTERN.matcher(item.line);
            if (!matcher.matches()) continue;
            TaskListItem listItem = new TaskListItem().done(TaskListBlockParser.isDone(matcher.group(1))).indent(item.indent / 2);
            inlineParser.parse(matcher.group(2), (Node)listItem);
            this.block.appendChild((Node)listItem);
        }
    }

    @Nullable
    private static String line(@NonNull ParserState state) {
        CharSequence lineRaw = state.getLine();
        return lineRaw != null ? lineRaw.toString() : null;
    }

    private static int length(@Nullable CharSequence text) {
        return text != null ? text.length() : 0;
    }

    private static boolean isDone(@NonNull String value) {
        return "X".equals(value) || "x".equals(value);
    }

    private static class Item {
        final String line;
        final int indent;

        Item(@NonNull String line, int indent) {
            this.line = line;
            this.indent = indent;
        }
    }

    static class Factory
    extends AbstractBlockParserFactory {
        Factory() {
        }

        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            String line = TaskListBlockParser.line(state);
            if (line != null && line.length() > 0 && PATTERN.matcher(line).matches()) {
                int length = line.length();
                int index = state.getIndex();
                int atIndex = index != 0 ? index + (length - index) : length;
                return BlockStart.of((BlockParser[])new BlockParser[]{new TaskListBlockParser(line, state.getIndent())}).atIndex(atIndex);
            }
            return BlockStart.none();
        }
    }
}

