/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.style.LeadingMarginSpan;
import ru.noties.markwon.spans.LeadingMarginUtils;
import ru.noties.markwon.spans.SpannableTheme;

public class TaskListSpan
implements LeadingMarginSpan {
    private static final int[] STATE_CHECKED = new int[]{0x10100A0};
    private static final int[] STATE_NONE = new int[0];
    private final SpannableTheme theme;
    private final int blockIndent;
    private final boolean isDone;

    public TaskListSpan(@NonNull SpannableTheme theme, int blockIndent, boolean isDone) {
        this.theme = theme;
        this.blockIndent = blockIndent;
        this.isDone = isDone;
    }

    public int getLeadingMargin(boolean first) {
        return this.theme.getBlockMargin() * this.blockIndent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        if (!first || !LeadingMarginUtils.selfStart(start, text, this)) {
            return;
        }
        Drawable drawable = this.theme.getTaskListDrawable();
        if (drawable == null) {
            return;
        }
        int save = c.save();
        try {
            int width = this.theme.getBlockMargin();
            int height = bottom - top;
            int w = (int)((float)width * 0.75f + 0.5f);
            int h = (int)((float)height * 0.75f + 0.5f);
            drawable.setBounds(0, 0, w, h);
            if (drawable.isStateful()) {
                int[] state = this.isDone ? STATE_CHECKED : STATE_NONE;
                drawable.setState(state);
            }
            int l = dir > 0 ? x + width * (this.blockIndent - 1) + (width - w) / 2 : x - width * this.blockIndent + (width - w) / 2;
            int t = top + (height - h) / 2;
            c.translate((float)l, (float)t);
            drawable.draw(c);
        }
        finally {
            c.restoreToCount(save);
        }
    }
}

