/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.spans;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.AttrRes;
import android.support.annotation.ColorInt;
import android.support.annotation.Dimension;
import android.support.annotation.FloatRange;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.text.TextPaint;
import android.util.TypedValue;
import java.util.Arrays;
import java.util.Locale;
import ru.noties.markwon.spans.ColorUtils;
import ru.noties.markwon.spans.TaskListDrawable;

public class SpannableTheme {
    protected static final int BLOCK_QUOTE_DEF_COLOR_ALPHA = 25;
    protected static final int CODE_DEF_BACKGROUND_COLOR_ALPHA = 25;
    protected static final float CODE_DEF_TEXT_SIZE_RATIO = 0.87f;
    protected static final int HEADING_DEF_BREAK_COLOR_ALPHA = 75;
    private static final float[] HEADING_SIZES = new float[]{2.0f, 1.5f, 1.17f, 1.0f, 0.83f, 0.67f};
    protected static final float SCRIPT_DEF_TEXT_SIZE_RATIO = 0.75f;
    protected static final int THEMATIC_BREAK_DEF_ALPHA = 25;
    protected static final int TABLE_BORDER_DEF_ALPHA = 75;
    protected static final int TABLE_ODD_ROW_DEF_ALPHA = 22;
    protected final int linkColor;
    protected final int blockMargin;
    protected final int blockQuoteWidth;
    protected final int blockQuoteColor;
    protected final int listItemColor;
    protected final int bulletListItemStrokeWidth;
    protected final int bulletWidth;
    protected final int codeTextColor;
    protected final int codeBlockTextColor;
    protected final int codeBackgroundColor;
    protected final int codeBlockBackgroundColor;
    protected final int codeMultilineMargin;
    protected final Typeface codeTypeface;
    protected final int codeTextSize;
    protected final int headingBreakHeight;
    protected final int headingBreakColor;
    protected final Typeface headingTypeface;
    protected final float[] headingTextSizeMultipliers;
    protected final float scriptTextSizeRatio;
    protected final int thematicBreakColor;
    protected final int thematicBreakHeight;
    protected final int tableCellPadding;
    protected final int tableBorderColor;
    protected final int tableBorderWidth;
    protected final int tableOddRowBackgroundColor;
    protected final int tableEventRowBackgroundColor;
    protected final int tableHeaderRowBackgroundColor;
    protected final Drawable taskListDrawable;

    @NonNull
    public static SpannableTheme create(@NonNull Context context) {
        return SpannableTheme.builderWithDefaults(context).build();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    @NonNull
    public static Builder builder(@NonNull SpannableTheme copyFrom) {
        return new Builder(copyFrom);
    }

    @NonNull
    public static Builder builderWithDefaults(@NonNull Context context) {
        int linkColor = SpannableTheme.resolve(context, 16842907);
        int backgroundColor = SpannableTheme.resolve(context, 0x1010031);
        Dip dip = new Dip(context);
        return new Builder().codeMultilineMargin(dip.toPx(8)).blockMargin(dip.toPx(24)).blockQuoteWidth(dip.toPx(4)).bulletListItemStrokeWidth(dip.toPx(1)).headingBreakHeight(dip.toPx(1)).thematicBreakHeight(dip.toPx(4)).tableCellPadding(dip.toPx(4)).tableBorderWidth(dip.toPx(1)).taskListDrawable(new TaskListDrawable(linkColor, linkColor, backgroundColor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int resolve(Context context, @AttrRes int attr2) {
        TypedValue typedValue = new TypedValue();
        int[] attrs = new int[]{attr2};
        TypedArray typedArray = context.obtainStyledAttributes(typedValue.data, attrs);
        try {
            int n = typedArray.getColor(0, 0);
            return n;
        }
        finally {
            typedArray.recycle();
        }
    }

    protected SpannableTheme(@NonNull Builder builder) {
        this.linkColor = builder.linkColor;
        this.blockMargin = builder.blockMargin;
        this.blockQuoteWidth = builder.blockQuoteWidth;
        this.blockQuoteColor = builder.blockQuoteColor;
        this.listItemColor = builder.listItemColor;
        this.bulletListItemStrokeWidth = builder.bulletListItemStrokeWidth;
        this.bulletWidth = builder.bulletWidth;
        this.codeTextColor = builder.codeTextColor;
        this.codeBlockTextColor = builder.codeBlockTextColor;
        this.codeBackgroundColor = builder.codeBackgroundColor;
        this.codeBlockBackgroundColor = builder.codeBlockBackgroundColor;
        this.codeMultilineMargin = builder.codeMultilineMargin;
        this.codeTypeface = builder.codeTypeface;
        this.codeTextSize = builder.codeTextSize;
        this.headingBreakHeight = builder.headingBreakHeight;
        this.headingBreakColor = builder.headingBreakColor;
        this.headingTypeface = builder.headingTypeface;
        this.headingTextSizeMultipliers = builder.headingTextSizeMultipliers;
        this.scriptTextSizeRatio = builder.scriptTextSizeRatio;
        this.thematicBreakColor = builder.thematicBreakColor;
        this.thematicBreakHeight = builder.thematicBreakHeight;
        this.tableCellPadding = builder.tableCellPadding;
        this.tableBorderColor = builder.tableBorderColor;
        this.tableBorderWidth = builder.tableBorderWidth;
        this.tableOddRowBackgroundColor = builder.tableOddRowBackgroundColor;
        this.tableEventRowBackgroundColor = builder.tableEvenRowBackgroundColor;
        this.tableHeaderRowBackgroundColor = builder.tableHeaderRowBackgroundColor;
        this.taskListDrawable = builder.taskListDrawable;
    }

    public void applyLinkStyle(@NonNull TextPaint paint) {
        paint.setUnderlineText(true);
        if (this.linkColor != 0) {
            paint.setColor(this.linkColor);
        } else {
            paint.setColor(paint.linkColor);
        }
    }

    public void applyLinkStyle(@NonNull Paint paint) {
        paint.setUnderlineText(true);
        if (this.linkColor != 0) {
            paint.setColor(this.linkColor);
        } else if (paint instanceof TextPaint) {
            paint.setColor(((TextPaint)paint).linkColor);
        }
    }

    public void applyBlockQuoteStyle(@NonNull Paint paint) {
        int color = this.blockQuoteColor == 0 ? ColorUtils.applyAlpha(paint.getColor(), 25) : this.blockQuoteColor;
        paint.setStyle(Paint.Style.FILL);
        paint.setColor(color);
    }

    public int getBlockMargin() {
        return this.blockMargin;
    }

    public int getBlockQuoteWidth() {
        int out = this.blockQuoteWidth == 0 ? (int)((float)this.blockMargin * 0.25f + 0.5f) : this.blockQuoteWidth;
        return out;
    }

    public void applyListItemStyle(@NonNull Paint paint) {
        int color = this.listItemColor != 0 ? this.listItemColor : paint.getColor();
        paint.setColor(color);
        if (this.bulletListItemStrokeWidth != 0) {
            paint.setStrokeWidth((float)this.bulletListItemStrokeWidth);
        }
    }

    public int getBulletWidth(int height) {
        int min = Math.min(this.blockMargin, height) / 2;
        int width = this.bulletWidth == 0 || this.bulletWidth > min ? min : this.bulletWidth;
        return width;
    }

    public void applyCodeTextStyle(@NonNull Paint paint, boolean multiline) {
        if (multiline && this.codeBlockTextColor != 0) {
            paint.setColor(this.codeBlockTextColor);
        } else if (this.codeTextColor != 0) {
            paint.setColor(this.codeTextColor);
        }
        if (this.codeTypeface != null) {
            paint.setTypeface(this.codeTypeface);
            if (this.codeTextSize != 0) {
                paint.setTextSize((float)this.codeTextSize);
            }
        } else {
            paint.setTypeface(Typeface.MONOSPACE);
            float textSize = this.codeTextSize != 0 ? (float)this.codeTextSize : paint.getTextSize() * 0.87f;
            paint.setTextSize(textSize);
        }
    }

    public int getCodeMultilineMargin() {
        return this.codeMultilineMargin;
    }

    public int getCodeBackgroundColor(@NonNull Paint paint, boolean multiline) {
        int color = multiline && this.codeBlockBackgroundColor != 0 ? this.codeBlockBackgroundColor : (this.codeBackgroundColor != 0 ? this.codeBackgroundColor : ColorUtils.applyAlpha(paint.getColor(), 25));
        return color;
    }

    public void applyHeadingTextStyle(@NonNull Paint paint, @IntRange(from=1L, to=6L) int level) {
        float[] textSizes;
        if (this.headingTypeface == null) {
            paint.setFakeBoldText(true);
        } else {
            paint.setTypeface(this.headingTypeface);
        }
        float[] fArray = textSizes = this.headingTextSizeMultipliers != null ? this.headingTextSizeMultipliers : HEADING_SIZES;
        if (textSizes == null || textSizes.length < level) {
            throw new IllegalStateException(String.format(Locale.US, "Supplied heading level: %d is invalid, where configured heading sizes are: `%s`", level, Arrays.toString(textSizes)));
        }
        paint.setTextSize(paint.getTextSize() * textSizes[level - 1]);
    }

    public void applyHeadingBreakStyle(@NonNull Paint paint) {
        int color = this.headingBreakColor != 0 ? this.headingBreakColor : ColorUtils.applyAlpha(paint.getColor(), 75);
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
        if (this.headingBreakHeight >= 0) {
            paint.setStrokeWidth((float)this.headingBreakHeight);
        }
    }

    public void applySuperScriptStyle(@NonNull TextPaint paint) {
        float ratio = Float.compare(this.scriptTextSizeRatio, 0.0f) == 0 ? 0.75f : this.scriptTextSizeRatio;
        paint.setTextSize(paint.getTextSize() * ratio);
        paint.baselineShift += (int)(paint.ascent() / 2.0f);
    }

    public void applySubScriptStyle(@NonNull TextPaint paint) {
        float ratio = Float.compare(this.scriptTextSizeRatio, 0.0f) == 0 ? 0.75f : this.scriptTextSizeRatio;
        paint.setTextSize(paint.getTextSize() * ratio);
        paint.baselineShift -= (int)(paint.ascent() / 2.0f);
    }

    public void applyThematicBreakStyle(@NonNull Paint paint) {
        int color = this.thematicBreakColor != 0 ? this.thematicBreakColor : ColorUtils.applyAlpha(paint.getColor(), 25);
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
        if (this.thematicBreakHeight >= 0) {
            paint.setStrokeWidth((float)this.thematicBreakHeight);
        }
    }

    public int tableCellPadding() {
        return this.tableCellPadding;
    }

    public int tableBorderWidth(@NonNull Paint paint) {
        int out = this.tableBorderWidth == -1 ? (int)(paint.getStrokeWidth() + 0.5f) : this.tableBorderWidth;
        return out;
    }

    public void applyTableBorderStyle(@NonNull Paint paint) {
        int color = this.tableBorderColor == 0 ? ColorUtils.applyAlpha(paint.getColor(), 75) : this.tableBorderColor;
        paint.setColor(color);
        paint.setStyle(Paint.Style.STROKE);
    }

    public void applyTableOddRowStyle(@NonNull Paint paint) {
        int color = this.tableOddRowBackgroundColor == 0 ? ColorUtils.applyAlpha(paint.getColor(), 22) : this.tableOddRowBackgroundColor;
        paint.setColor(color);
        paint.setStyle(Paint.Style.FILL);
    }

    public void applyTableEvenRowStyle(@NonNull Paint paint) {
        paint.setColor(this.tableEventRowBackgroundColor);
        paint.setStyle(Paint.Style.FILL);
    }

    public void applyTableHeaderRowStyle(@NonNull Paint paint) {
        paint.setColor(this.tableHeaderRowBackgroundColor);
        paint.setStyle(Paint.Style.FILL);
    }

    @Nullable
    public Drawable getTaskListDrawable() {
        return this.taskListDrawable;
    }

    private static class Dip {
        private final float density;

        Dip(@NonNull Context context) {
            this.density = context.getResources().getDisplayMetrics().density;
        }

        int toPx(int dp) {
            return (int)((float)dp * this.density + 0.5f);
        }
    }

    public static class Builder {
        private int linkColor;
        private int blockMargin;
        private int blockQuoteWidth;
        private int blockQuoteColor;
        private int listItemColor;
        private int bulletListItemStrokeWidth;
        private int bulletWidth;
        private int codeTextColor;
        private int codeBlockTextColor;
        private int codeBackgroundColor;
        private int codeBlockBackgroundColor;
        private int codeMultilineMargin;
        private Typeface codeTypeface;
        private int codeTextSize;
        private int headingBreakHeight = -1;
        private int headingBreakColor;
        private Typeface headingTypeface;
        private float[] headingTextSizeMultipliers;
        private float scriptTextSizeRatio;
        private int thematicBreakColor;
        private int thematicBreakHeight = -1;
        private int tableCellPadding;
        private int tableBorderColor;
        private int tableBorderWidth = -1;
        private int tableOddRowBackgroundColor;
        private int tableEvenRowBackgroundColor;
        private int tableHeaderRowBackgroundColor;
        private Drawable taskListDrawable;

        Builder() {
        }

        Builder(@NonNull SpannableTheme theme) {
            this.linkColor = theme.linkColor;
            this.blockMargin = theme.blockMargin;
            this.blockQuoteWidth = theme.blockQuoteWidth;
            this.blockQuoteColor = theme.blockQuoteColor;
            this.listItemColor = theme.listItemColor;
            this.bulletListItemStrokeWidth = theme.bulletListItemStrokeWidth;
            this.bulletWidth = theme.bulletWidth;
            this.codeTextColor = theme.codeTextColor;
            this.codeBlockTextColor = theme.codeBlockTextColor;
            this.codeBackgroundColor = theme.codeBackgroundColor;
            this.codeBlockBackgroundColor = theme.codeBlockBackgroundColor;
            this.codeMultilineMargin = theme.codeMultilineMargin;
            this.codeTypeface = theme.codeTypeface;
            this.codeTextSize = theme.codeTextSize;
            this.headingBreakHeight = theme.headingBreakHeight;
            this.headingBreakColor = theme.headingBreakColor;
            this.headingTypeface = theme.headingTypeface;
            this.headingTextSizeMultipliers = theme.headingTextSizeMultipliers;
            this.scriptTextSizeRatio = theme.scriptTextSizeRatio;
            this.thematicBreakColor = theme.thematicBreakColor;
            this.thematicBreakHeight = theme.thematicBreakHeight;
            this.tableCellPadding = theme.tableCellPadding;
            this.tableBorderColor = theme.tableBorderColor;
            this.tableBorderWidth = theme.tableBorderWidth;
            this.tableOddRowBackgroundColor = theme.tableOddRowBackgroundColor;
            this.taskListDrawable = theme.taskListDrawable;
        }

        @NonNull
        public Builder linkColor(@ColorInt int linkColor) {
            this.linkColor = linkColor;
            return this;
        }

        @NonNull
        public Builder blockMargin(@Dimension int blockMargin) {
            this.blockMargin = blockMargin;
            return this;
        }

        @NonNull
        public Builder blockQuoteWidth(@Dimension int blockQuoteWidth) {
            this.blockQuoteWidth = blockQuoteWidth;
            return this;
        }

        @NonNull
        public Builder blockQuoteColor(@ColorInt int blockQuoteColor) {
            this.blockQuoteColor = blockQuoteColor;
            return this;
        }

        @NonNull
        public Builder listItemColor(@ColorInt int listItemColor) {
            this.listItemColor = listItemColor;
            return this;
        }

        @NonNull
        public Builder bulletListItemStrokeWidth(@Dimension int bulletListItemStrokeWidth) {
            this.bulletListItemStrokeWidth = bulletListItemStrokeWidth;
            return this;
        }

        @NonNull
        public Builder bulletWidth(@Dimension int bulletWidth) {
            this.bulletWidth = bulletWidth;
            return this;
        }

        @NonNull
        public Builder codeTextColor(@ColorInt int codeTextColor) {
            this.codeTextColor = codeTextColor;
            return this;
        }

        @NonNull
        public Builder codeBlockTextColor(@ColorInt int codeBlockTextColor) {
            this.codeBlockTextColor = codeBlockTextColor;
            return this;
        }

        @NonNull
        public Builder codeBackgroundColor(@ColorInt int codeBackgroundColor) {
            this.codeBackgroundColor = codeBackgroundColor;
            return this;
        }

        @NonNull
        public Builder codeBlockBackgroundColor(@ColorInt int codeBlockBackgroundColor) {
            this.codeBlockBackgroundColor = codeBlockBackgroundColor;
            return this;
        }

        @NonNull
        public Builder codeMultilineMargin(@Dimension int codeMultilineMargin) {
            this.codeMultilineMargin = codeMultilineMargin;
            return this;
        }

        @NonNull
        public Builder codeTypeface(@NonNull Typeface codeTypeface) {
            this.codeTypeface = codeTypeface;
            return this;
        }

        @NonNull
        public Builder codeTextSize(@Dimension int codeTextSize) {
            this.codeTextSize = codeTextSize;
            return this;
        }

        @NonNull
        public Builder headingBreakHeight(@Dimension int headingBreakHeight) {
            this.headingBreakHeight = headingBreakHeight;
            return this;
        }

        @NonNull
        public Builder headingBreakColor(@ColorInt int headingBreakColor) {
            this.headingBreakColor = headingBreakColor;
            return this;
        }

        @NonNull
        public Builder headingTypeface(@NonNull Typeface headingTypeface) {
            this.headingTypeface = headingTypeface;
            return this;
        }

        @NonNull
        public Builder headingTextSizeMultipliers(@Size(value=6L) @NonNull float[] headingTextSizeMultipliers) {
            this.headingTextSizeMultipliers = headingTextSizeMultipliers;
            return this;
        }

        @NonNull
        public Builder scriptTextSizeRatio(@FloatRange(from=0.0, to=3.4028234663852886E38) float scriptTextSizeRatio) {
            this.scriptTextSizeRatio = scriptTextSizeRatio;
            return this;
        }

        @NonNull
        public Builder thematicBreakColor(@ColorInt int thematicBreakColor) {
            this.thematicBreakColor = thematicBreakColor;
            return this;
        }

        @NonNull
        public Builder thematicBreakHeight(@Dimension int thematicBreakHeight) {
            this.thematicBreakHeight = thematicBreakHeight;
            return this;
        }

        @NonNull
        public Builder tableCellPadding(@Dimension int tableCellPadding) {
            this.tableCellPadding = tableCellPadding;
            return this;
        }

        @NonNull
        public Builder tableBorderColor(@ColorInt int tableBorderColor) {
            this.tableBorderColor = tableBorderColor;
            return this;
        }

        @NonNull
        public Builder tableBorderWidth(@Dimension int tableBorderWidth) {
            this.tableBorderWidth = tableBorderWidth;
            return this;
        }

        @NonNull
        public Builder tableOddRowBackgroundColor(@ColorInt int tableOddRowBackgroundColor) {
            this.tableOddRowBackgroundColor = tableOddRowBackgroundColor;
            return this;
        }

        @NonNull
        public Builder tableEvenRowBackgroundColor(@ColorInt int tableEvenRowBackgroundColor) {
            this.tableEvenRowBackgroundColor = tableEvenRowBackgroundColor;
            return this;
        }

        @NonNull
        public Builder tableHeaderRowBackgroundColor(int tableHeaderRowBackgroundColor) {
            this.tableHeaderRowBackgroundColor = tableHeaderRowBackgroundColor;
            return this;
        }

        @NonNull
        public Builder taskListDrawable(@NonNull Drawable taskListDrawable) {
            this.taskListDrawable = taskListDrawable;
            return this;
        }

        @NonNull
        public SpannableTheme build() {
            return new SpannableTheme(this);
        }
    }
}

