/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.style.LeadingMarginSpan;
import ru.noties.markwon.spans.LeadingMarginUtils;
import ru.noties.markwon.spans.ObjectsPool;
import ru.noties.markwon.spans.SpannableTheme;

public class OrderedListItemSpan
implements LeadingMarginSpan {
    private final SpannableTheme theme;
    private final String number;
    private final Paint paint = ObjectsPool.paint();
    private int margin;

    public OrderedListItemSpan(@NonNull SpannableTheme theme, @NonNull String number) {
        this.theme = theme;
        this.number = number;
    }

    public int getLeadingMargin(boolean first) {
        return this.margin > 0 ? this.margin : this.theme.getBlockMargin();
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        if (!first || !LeadingMarginUtils.selfStart(start, text, this)) {
            return;
        }
        this.paint.set(p);
        this.theme.applyListItemStyle(this.paint);
        int numberWidth = (int)(p.measureText(this.number) + 0.5f);
        int width = this.theme.getBlockMargin();
        if (numberWidth > width) {
            width = numberWidth;
            this.margin = numberWidth;
        } else {
            this.margin = 0;
        }
        int left = dir > 0 ? x + width * dir - numberWidth : x + width * dir + (width - numberWidth);
        c.drawText(this.number, (float)left, (float)baseline, this.paint);
    }
}

