/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.NonNull;
import android.text.Layout;
import android.text.TextPaint;
import android.text.style.LeadingMarginSpan;
import android.text.style.MetricAffectingSpan;
import ru.noties.markwon.spans.ObjectsPool;
import ru.noties.markwon.spans.SpannableTheme;

public class CodeSpan
extends MetricAffectingSpan
implements LeadingMarginSpan {
    private final SpannableTheme theme;
    private final Rect rect = ObjectsPool.rect();
    private final Paint paint = ObjectsPool.paint();
    private final boolean multiline;

    public CodeSpan(@NonNull SpannableTheme theme, boolean multiline) {
        this.theme = theme;
        this.multiline = multiline;
    }

    public void updateMeasureState(TextPaint p) {
        this.apply(p);
    }

    public void updateDrawState(TextPaint ds) {
        this.apply(ds);
        if (!this.multiline) {
            ds.bgColor = this.theme.getCodeBackgroundColor((Paint)ds, false);
        }
    }

    private void apply(TextPaint p) {
        this.theme.applyCodeTextStyle((Paint)p, this.multiline);
    }

    public int getLeadingMargin(boolean first) {
        return this.multiline ? this.theme.getCodeMultilineMargin() : 0;
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        if (this.multiline) {
            int right;
            int left;
            this.paint.setStyle(Paint.Style.FILL);
            this.paint.setColor(this.theme.getCodeBackgroundColor(p, true));
            if (dir > 0) {
                left = x;
                right = c.getWidth();
            } else {
                left = x - c.getWidth();
                right = x;
            }
            this.rect.set(left, top, right, bottom);
            c.drawRect(this.rect, this.paint);
        }
    }
}

