/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.spans;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import ru.noties.markwon.renderer.ImageSize;
import ru.noties.markwon.renderer.ImageSizeResolver;

public class AsyncDrawable
extends Drawable {
    private final String destination;
    private final Loader loader;
    private final ImageSize imageSize;
    private final ImageSizeResolver imageSizeResolver;
    private Drawable result;
    private Drawable.Callback callback;
    private int canvasWidth;
    private float textSize;

    public AsyncDrawable(@NonNull String destination, @NonNull Loader loader, @Nullable ImageSizeResolver imageSizeResolver, @Nullable ImageSize imageSize) {
        this.destination = destination;
        this.loader = loader;
        this.imageSizeResolver = imageSizeResolver;
        this.imageSize = imageSize;
    }

    @NonNull
    public String getDestination() {
        return this.destination;
    }

    public Drawable getResult() {
        return this.result;
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public boolean isAttached() {
        return this.getCallback() != null;
    }

    public void setCallback2(@Nullable Drawable.Callback callback) {
        this.callback = callback;
        super.setCallback(callback);
        if (callback != null) {
            this.loader.load(this.destination, this);
        } else {
            if (this.result != null) {
                this.result.setCallback(null);
                if (this.result instanceof Animatable) {
                    ((Animatable)this.result).stop();
                }
            }
            this.loader.cancel(this.destination);
        }
    }

    public void setResult(@NonNull Drawable result) {
        if (this.result != null) {
            this.result.setCallback(null);
        }
        this.result = result;
        this.result.setCallback(this.callback);
        Rect bounds = this.resolveBounds();
        result.setBounds(bounds);
        this.setBounds(bounds);
        this.invalidateSelf();
    }

    public void initWithKnownDimensions(int width, float textSize) {
        this.canvasWidth = width;
        this.textSize = textSize;
    }

    public void draw(@NonNull Canvas canvas) {
        if (this.hasResult()) {
            this.result.draw(canvas);
        }
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        int opacity = this.hasResult() ? this.result.getOpacity() : -2;
        return opacity;
    }

    public int getIntrinsicWidth() {
        int out = this.hasResult() ? this.result.getIntrinsicWidth() : 0;
        return out;
    }

    public int getIntrinsicHeight() {
        int out = this.hasResult() ? this.result.getIntrinsicHeight() : 0;
        return out;
    }

    @NonNull
    private Rect resolveBounds() {
        return this.imageSizeResolver != null ? this.imageSizeResolver.resolveImageSize(this.imageSize, this.result.getBounds(), this.canvasWidth, this.textSize) : this.result.getBounds();
    }

    public static interface Loader {
        public void load(@NonNull String var1, @NonNull AsyncDrawable var2);

        public void cancel(@NonNull String var1);
    }
}

