/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.renderer.html2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import java.util.Map;
import ru.noties.markwon.SpannableBuilder;
import ru.noties.markwon.SpannableConfiguration;
import ru.noties.markwon.html.api.HtmlTag;
import ru.noties.markwon.html.api.MarkwonHtmlParser;
import ru.noties.markwon.renderer.html2.MarkwonHtmlRenderer;
import ru.noties.markwon.renderer.html2.tag.TagHandler;

class MarkwonHtmlRendererImpl
extends MarkwonHtmlRenderer {
    private final Map<String, TagHandler> tagHandlers;

    MarkwonHtmlRendererImpl(@NonNull Map<String, TagHandler> tagHandlers) {
        this.tagHandlers = tagHandlers;
    }

    @Override
    public void render(final @NonNull SpannableConfiguration configuration, final @NonNull SpannableBuilder builder, @NonNull MarkwonHtmlParser parser) {
        int end = !configuration.htmlAllowNonClosedTags() ? -1 : builder.length();
        parser.flushInlineTags(end, (MarkwonHtmlParser.FlushAction)new MarkwonHtmlParser.FlushAction<HtmlTag.Inline>(){

            public void apply(@NonNull List<HtmlTag.Inline> tags) {
                for (HtmlTag.Inline inline : tags) {
                    TagHandler handler;
                    if (!inline.isClosed() || (handler = MarkwonHtmlRendererImpl.this.tagHandler(inline.name())) == null) continue;
                    handler.handle(configuration, builder, (HtmlTag)inline);
                }
            }
        });
        parser.flushBlockTags(end, (MarkwonHtmlParser.FlushAction)new MarkwonHtmlParser.FlushAction<HtmlTag.Block>(){

            public void apply(@NonNull List<HtmlTag.Block> tags) {
                for (HtmlTag.Block block : tags) {
                    if (!block.isClosed()) continue;
                    TagHandler handler = MarkwonHtmlRendererImpl.this.tagHandler(block.name());
                    if (handler != null) {
                        handler.handle(configuration, builder, (HtmlTag)block);
                        continue;
                    }
                    this.apply(block.children());
                }
            }
        });
        parser.reset();
    }

    @Override
    @Nullable
    public TagHandler tagHandler(@NonNull String tagName) {
        return this.tagHandlers.get(tagName);
    }
}

