/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon.renderer;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.commonmark.ext.gfm.strikethrough.Strikethrough;
import org.commonmark.ext.gfm.tables.TableBody;
import org.commonmark.ext.gfm.tables.TableCell;
import org.commonmark.ext.gfm.tables.TableHead;
import org.commonmark.ext.gfm.tables.TableRow;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.Code;
import org.commonmark.node.CustomBlock;
import org.commonmark.node.CustomNode;
import org.commonmark.node.Document;
import org.commonmark.node.Emphasis;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.IndentedCodeBlock;
import org.commonmark.node.Link;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.StrongEmphasis;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import ru.noties.markwon.SpannableBuilder;
import ru.noties.markwon.SpannableConfiguration;
import ru.noties.markwon.SpannableFactory;
import ru.noties.markwon.html.api.MarkwonHtmlParser;
import ru.noties.markwon.spans.SpannableTheme;
import ru.noties.markwon.spans.TableRowSpan;
import ru.noties.markwon.tasklist.TaskListBlock;
import ru.noties.markwon.tasklist.TaskListItem;

public class SpannableMarkdownVisitor
extends AbstractVisitor {
    private final SpannableConfiguration configuration;
    private final SpannableBuilder builder;
    private final MarkwonHtmlParser htmlParser;
    private final SpannableTheme theme;
    private final SpannableFactory factory;
    private int blockQuoteIndent;
    private int listLevel;
    private List<TableRowSpan.Cell> pendingTableRow;
    private boolean tableRowIsHeader;
    private int tableRows;

    public SpannableMarkdownVisitor(@NonNull SpannableConfiguration configuration, @NonNull SpannableBuilder builder) {
        this.configuration = configuration;
        this.builder = builder;
        this.htmlParser = configuration.htmlParser();
        this.theme = configuration.theme();
        this.factory = configuration.factory();
    }

    public void visit(Document document) {
        super.visit(document);
        this.configuration.htmlRenderer().render(this.configuration, this.builder, this.htmlParser);
    }

    public void visit(Text text) {
        this.builder.append(text.getLiteral());
    }

    public void visit(StrongEmphasis strongEmphasis) {
        int length = this.builder.length();
        this.visitChildren((Node)strongEmphasis);
        this.setSpan(length, this.factory.strongEmphasis());
    }

    public void visit(Emphasis emphasis) {
        int length = this.builder.length();
        this.visitChildren((Node)emphasis);
        this.setSpan(length, this.factory.emphasis());
    }

    public void visit(BlockQuote blockQuote) {
        this.newLine();
        if (this.blockQuoteIndent != 0) {
            this.builder.append('\n');
        }
        int length = this.builder.length();
        ++this.blockQuoteIndent;
        this.visitChildren((Node)blockQuote);
        this.setSpan(length, this.factory.blockQuote(this.theme));
        --this.blockQuoteIndent;
        if (SpannableMarkdownVisitor.hasNext((Node)blockQuote)) {
            this.newLine();
            if (this.blockQuoteIndent == 0) {
                this.builder.append('\n');
            }
        }
    }

    public void visit(Code code) {
        int length = this.builder.length();
        this.builder.append('\u00a0');
        this.builder.append(code.getLiteral());
        this.builder.append('\u00a0');
        this.setSpan(length, this.factory.code(this.theme, false));
    }

    public void visit(FencedCodeBlock fencedCodeBlock) {
        this.visitCodeBlock(fencedCodeBlock.getInfo(), fencedCodeBlock.getLiteral(), (Node)fencedCodeBlock);
    }

    public void visit(IndentedCodeBlock indentedCodeBlock) {
        this.visitCodeBlock(null, indentedCodeBlock.getLiteral(), (Node)indentedCodeBlock);
    }

    private void visitCodeBlock(@Nullable String info, @NonNull String code, @NonNull Node node) {
        this.newLine();
        int length = this.builder.length();
        this.builder.append('\u00a0').append('\n');
        this.builder.append(this.configuration.syntaxHighlight().highlight(info, code));
        this.newLine();
        this.builder.append('\u00a0');
        this.setSpan(length, this.factory.code(this.theme, true));
        if (SpannableMarkdownVisitor.hasNext(node)) {
            this.newLine();
            this.builder.append('\n');
        }
    }

    public void visit(BulletList bulletList) {
        this.visitList((Node)bulletList);
    }

    public void visit(OrderedList orderedList) {
        this.visitList((Node)orderedList);
    }

    private void visitList(Node node) {
        this.newLine();
        this.visitChildren(node);
        if (SpannableMarkdownVisitor.hasNext(node)) {
            this.newLine();
            if (this.listLevel == 0 && this.blockQuoteIndent == 0) {
                this.builder.append('\n');
            }
        }
    }

    public void visit(ListItem listItem) {
        int length = this.builder.length();
        ++this.blockQuoteIndent;
        ++this.listLevel;
        Block parent = listItem.getParent();
        if (parent instanceof OrderedList) {
            int start = ((OrderedList)parent).getStartNumber();
            this.visitChildren((Node)listItem);
            this.setSpan(length, this.factory.orderedListItem(this.theme, start));
            OrderedList orderedList = (OrderedList)parent;
            orderedList.setStartNumber(orderedList.getStartNumber() + 1);
        } else {
            this.visitChildren((Node)listItem);
            this.setSpan(length, this.factory.bulletListItem(this.theme, this.listLevel - 1));
        }
        --this.blockQuoteIndent;
        --this.listLevel;
        if (SpannableMarkdownVisitor.hasNext((Node)listItem)) {
            this.newLine();
        }
    }

    public void visit(ThematicBreak thematicBreak) {
        this.newLine();
        int length = this.builder.length();
        this.builder.append('\u00a0');
        this.setSpan(length, this.factory.thematicBreak(this.theme));
        if (SpannableMarkdownVisitor.hasNext((Node)thematicBreak)) {
            this.newLine();
            this.builder.append('\n');
        }
    }

    public void visit(Heading heading) {
        this.newLine();
        int length = this.builder.length();
        this.visitChildren((Node)heading);
        this.setSpan(length, this.factory.heading(this.theme, heading.getLevel()));
        if (SpannableMarkdownVisitor.hasNext((Node)heading)) {
            this.newLine();
            this.builder.append('\n');
        }
    }

    public void visit(SoftLineBreak softLineBreak) {
        if (this.configuration.softBreakAddsNewLine()) {
            this.newLine();
        } else {
            this.builder.append(' ');
        }
    }

    public void visit(HardLineBreak hardLineBreak) {
        this.newLine();
    }

    public void visit(CustomBlock customBlock) {
        if (customBlock instanceof TaskListBlock) {
            ++this.blockQuoteIndent;
            this.visitChildren((Node)customBlock);
            --this.blockQuoteIndent;
            if (SpannableMarkdownVisitor.hasNext((Node)customBlock)) {
                this.newLine();
                this.builder.append('\n');
            }
        } else {
            super.visit(customBlock);
        }
    }

    public void visit(CustomNode customNode) {
        if (customNode instanceof Strikethrough) {
            int length = this.builder.length();
            this.visitChildren((Node)customNode);
            this.setSpan(length, this.factory.strikethrough());
        } else if (customNode instanceof TaskListItem) {
            TaskListItem listItem = (TaskListItem)customNode;
            int length = this.builder.length();
            this.blockQuoteIndent += listItem.indent();
            this.visitChildren((Node)customNode);
            this.setSpan(length, this.factory.taskListItem(this.theme, this.blockQuoteIndent, listItem.done()));
            if (SpannableMarkdownVisitor.hasNext((Node)customNode)) {
                this.newLine();
            }
            this.blockQuoteIndent -= listItem.indent();
        } else if (!this.handleTableNodes(customNode)) {
            super.visit(customNode);
        }
    }

    private boolean handleTableNodes(CustomNode node) {
        boolean handled;
        if (node instanceof TableBody) {
            this.visitChildren((Node)node);
            this.tableRows = 0;
            handled = true;
            if (SpannableMarkdownVisitor.hasNext((Node)node)) {
                this.newLine();
                this.builder.append('\n');
            }
        } else if (node instanceof TableRow || node instanceof TableHead) {
            int length = this.builder.length();
            this.visitChildren((Node)node);
            if (this.pendingTableRow != null) {
                boolean addNewLine;
                int builderLength = this.builder.length();
                boolean bl = addNewLine = builderLength > 0 && '\n' != this.builder.charAt(builderLength - 1);
                if (addNewLine) {
                    this.builder.append('\n');
                }
                this.builder.append('\u00a0');
                Object span = this.factory.tableRow(this.theme, this.pendingTableRow, this.tableRowIsHeader, this.tableRows % 2 == 1);
                this.tableRows = this.tableRowIsHeader ? 0 : this.tableRows + 1;
                this.setSpan(addNewLine ? length + 1 : length, span);
                this.pendingTableRow = null;
            }
            handled = true;
        } else if (node instanceof TableCell) {
            TableCell cell = (TableCell)node;
            int length = this.builder.length();
            this.visitChildren((Node)cell);
            if (this.pendingTableRow == null) {
                this.pendingTableRow = new ArrayList<TableRowSpan.Cell>(2);
            }
            this.pendingTableRow.add(new TableRowSpan.Cell(SpannableMarkdownVisitor.tableCellAlignment(cell.getAlignment()), this.builder.removeFromEnd(length)));
            this.tableRowIsHeader = cell.isHeader();
            handled = true;
        } else {
            handled = false;
        }
        return handled;
    }

    public void visit(Paragraph paragraph) {
        boolean inTightList = this.isInTightList(paragraph);
        if (!inTightList) {
            this.newLine();
        }
        int length = this.builder.length();
        this.visitChildren((Node)paragraph);
        this.setSpan(length, this.factory.paragraph(inTightList));
        if (SpannableMarkdownVisitor.hasNext((Node)paragraph) && !inTightList) {
            this.newLine();
            if (this.blockQuoteIndent == 0) {
                this.builder.append('\n');
            }
        }
    }

    public void visit(Image image) {
        Node parent;
        int length = this.builder.length();
        this.visitChildren((Node)image);
        if (length == this.builder.length()) {
            this.builder.append('\ufffc');
        }
        boolean link = (parent = image.getParent()) != null && parent instanceof Link;
        String destination = this.configuration.urlProcessor().process(image.getDestination());
        this.setSpan(length, this.factory.image(this.theme, destination, this.configuration.asyncDrawableLoader(), this.configuration.imageSizeResolver(), null, link));
    }

    public void visit(HtmlBlock htmlBlock) {
        this.visitHtml(htmlBlock.getLiteral());
    }

    public void visit(HtmlInline htmlInline) {
        this.visitHtml(htmlInline.getLiteral());
    }

    private void visitHtml(@Nullable String html) {
        if (html != null) {
            this.htmlParser.processFragment((Appendable)this.builder, html);
        }
    }

    public void visit(Link link) {
        int length = this.builder.length();
        this.visitChildren((Node)link);
        String destination = this.configuration.urlProcessor().process(link.getDestination());
        this.setSpan(length, this.factory.link(this.theme, destination, this.configuration.linkResolver()));
    }

    private void setSpan(int start, @Nullable Object span) {
        SpannableBuilder.setSpans(this.builder, span, start, this.builder.length());
    }

    private void newLine() {
        if (this.builder.length() > 0 && '\n' != this.builder.lastChar()) {
            this.builder.append('\n');
        }
    }

    private boolean isInTightList(Paragraph paragraph) {
        Node gramps;
        Block parent = paragraph.getParent();
        if (parent != null && (gramps = parent.getParent()) != null && gramps instanceof ListBlock) {
            ListBlock list = (ListBlock)gramps;
            return list.isTight();
        }
        return false;
    }

    private static int tableCellAlignment(TableCell.Alignment alignment) {
        int out;
        if (alignment != null) {
            switch (alignment) {
                case CENTER: {
                    out = 1;
                    break;
                }
                case RIGHT: {
                    out = 2;
                    break;
                }
                default: {
                    out = 0;
                    break;
                }
            }
        } else {
            out = 0;
        }
        return out;
    }

    protected static boolean hasNext(@NonNull Node node) {
        return node.getNext() != null;
    }
}

