/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.markwon;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import ru.noties.markwon.SpannableStringBuilderImpl;
import ru.noties.markwon.SpannedReversed;

public class SpannableBuilder
implements Appendable,
CharSequence {
    private final StringBuilder builder;
    private final Deque<Span> spans = new ArrayDeque<Span>(8);

    public static void setSpans(@NonNull SpannableBuilder builder, @Nullable Object spans, int start, int end) {
        if (spans != null) {
            if (!SpannableBuilder.isPositionValid(builder.length(), start, end)) {
                return;
            }
            if (spans.getClass().isArray()) {
                for (Object o : (Object[])spans) {
                    builder.setSpan(o, start, end, 33);
                }
            } else {
                builder.setSpan(spans, start, end, 33);
            }
        }
    }

    private static boolean isPositionValid(int length, int start, int end) {
        return end > start && start >= 0 && end <= length;
    }

    public SpannableBuilder() {
        this("");
    }

    public SpannableBuilder(@NonNull CharSequence cs) {
        this.builder = new StringBuilder(cs);
        this.copySpans(0, cs);
    }

    @NonNull
    public SpannableBuilder append(@NonNull String text) {
        this.builder.append(text);
        return this;
    }

    @Override
    @NonNull
    public SpannableBuilder append(char c) {
        this.builder.append(c);
        return this;
    }

    @Override
    @NonNull
    public SpannableBuilder append(@NonNull CharSequence cs) {
        this.copySpans(this.length(), cs);
        this.builder.append(cs);
        return this;
    }

    @Override
    @NonNull
    public SpannableBuilder append(CharSequence csq, int start, int end) {
        CharSequence cs = csq.subSequence(start, end);
        this.copySpans(this.length(), cs);
        this.builder.append(cs);
        return this;
    }

    @NonNull
    public SpannableBuilder append(@NonNull CharSequence cs, @NonNull Object span) {
        int length = this.length();
        this.append(cs);
        this.setSpan(span, length);
        return this;
    }

    @NonNull
    public SpannableBuilder append(@NonNull CharSequence cs, @NonNull Object span, int flags) {
        int length = this.length();
        this.append(cs);
        this.setSpan(span, length, this.length(), flags);
        return this;
    }

    @NonNull
    public SpannableBuilder setSpan(@NonNull Object span, int start) {
        return this.setSpan(span, start, this.length());
    }

    @NonNull
    public SpannableBuilder setSpan(@NonNull Object span, int start, int end) {
        return this.setSpan(span, start, end, 33);
    }

    @NonNull
    public SpannableBuilder setSpan(@NonNull Object span, int start, int end, int flags) {
        this.spans.push(new Span(span, start, end, flags));
        return this;
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public char charAt(int index) {
        return this.builder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.builder.subSequence(start, end);
    }

    public char lastChar() {
        return this.builder.charAt(this.length() - 1);
    }

    @NonNull
    public CharSequence removeFromEnd(int start) {
        Span span;
        int end = this.length();
        SpannableStringBuilderImpl impl = new SpannableStringBuilderImpl(this.builder.subSequence(start, end));
        Iterator<Span> iterator = this.spans.iterator();
        while (iterator.hasNext() && (span = iterator.next()) != null) {
            if (span.start < start || span.end > end) continue;
            impl.setSpan(span.what, span.start - start, span.end - start, 33);
            iterator.remove();
        }
        this.builder.replace(start, end, "");
        return impl;
    }

    @Override
    @NonNull
    public String toString() {
        return this.builder.toString();
    }

    @NonNull
    public CharSequence text() {
        return this.spannableStringBuilder();
    }

    @NonNull
    public SpannableStringBuilder spannableStringBuilder() {
        SpannableStringBuilderImpl impl = new SpannableStringBuilderImpl(this.builder);
        for (Span span : this.spans) {
            impl.setSpan(span.what, span.start, span.end, span.flags);
        }
        return impl;
    }

    private void copySpans(int index, @Nullable CharSequence cs) {
        block5: {
            int length;
            if (!(cs instanceof Spanned)) break block5;
            Spanned spanned = (Spanned)cs;
            boolean reverse = spanned instanceof SpannedReversed;
            Object[] spans = spanned.getSpans(0, spanned.length(), Object.class);
            int n = length = spans != null ? spans.length : 0;
            if (length > 0) {
                if (reverse) {
                    for (int i = length - 1; i >= 0; --i) {
                        Object o = spans[i];
                        this.setSpan(o, index + spanned.getSpanStart(o), index + spanned.getSpanEnd(o), spanned.getSpanFlags(o));
                    }
                } else {
                    for (int i = 0; i < length; ++i) {
                        Object o = spans[i];
                        this.setSpan(o, index + spanned.getSpanStart(o), index + spanned.getSpanEnd(o), spanned.getSpanFlags(o));
                    }
                }
            }
        }
    }

    static class Span {
        final Object what;
        int start;
        int end;
        final int flags;

        Span(@NonNull Object what, int start, int end, int flags) {
            this.what = what;
            this.start = start;
            this.end = end;
            this.flags = flags;
        }
    }
}

