/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.jlatexmath.awt.geom;

import android.graphics.Canvas;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public class AffineTransform
implements Cloneable {
    private final AffineTransform parent;
    private final Canvas canvas;
    private int save = -1;
    private double scaleX = 1.0;
    private double scaleY = 1.0;
    private float translateX;
    private float translateY;

    public static AffineTransform create(Canvas canvas) {
        return new AffineTransform(null, canvas);
    }

    private AffineTransform(@Nullable AffineTransform parent, @NonNull Canvas canvas) {
        this.parent = parent;
        this.canvas = canvas;
    }

    public AffineTransform save() {
        AffineTransform transform = new AffineTransform(this, this.canvas);
        transform.setScale(this.scaleX, this.scaleY);
        transform.setTranslate(this.translateX, this.translateY);
        transform.save = this.canvas.save();
        return transform;
    }

    public AffineTransform restore() {
        if (this.save != -1) {
            this.canvas.restoreToCount(this.save);
            this.save = -1;
        }
        if (this.parent == null) {
            throw new IllegalStateException("Cannot restore root transform instance");
        }
        return this.parent;
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    public void scale(double v, double v1) {
        this.setScale(v, v1);
        this.canvas.scale((float)v, (float)v1);
    }

    public void translate(float x, float y) {
        this.canvas.translate(x, y);
        this.setTranslate(x, y);
    }

    public void setScale(double x, double y) {
        this.scaleX = x;
        this.scaleY = y;
    }

    public void setTranslate(float x, float y) {
        this.translateX = x;
        this.translateY = y;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public float translateX() {
        return this.translateX;
    }

    public float translateY() {
        return this.translateY;
    }

    public AffineTransform clone() {
        AffineTransform transform = new AffineTransform(this, this.canvas);
        transform.setScale(this.scaleX, this.scaleY);
        transform.setTranslate(this.translateX, this.translateY);
        transform.save = this.canvas.save();
        return transform;
    }
}

