/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.jlatexmath.awt.font;

import android.graphics.Paint;
import android.graphics.Rect;
import ru.noties.jlatexmath.awt.Font;
import ru.noties.jlatexmath.awt.Graphics2D;
import ru.noties.jlatexmath.awt.font.FontRenderContext;
import ru.noties.jlatexmath.awt.geom.Rectangle2D;

public class TextLayout {
    private final char[] chars;
    private final Font font;
    private final Rectangle2D bounds;

    public TextLayout(String str, Font font, FontRenderContext frc) {
        this.chars = str.toCharArray();
        this.font = font;
        Paint paint = new Paint(1);
        paint.setTypeface(font.typeface());
        paint.setTextSize(font.size());
        Rect rect = new Rect();
        paint.getTextBounds(str, 0, str.length(), rect);
        this.bounds = new Rectangle2D.Float(rect.left, rect.top, rect.width(), rect.height());
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void draw(Graphics2D g2, int i, int i1) {
        boolean differentFonts;
        Font current = g2.getFont();
        boolean bl = differentFonts = this.font != current;
        if (differentFonts) {
            g2.setFont(this.font);
        }
        g2.drawChars(this.chars, 0, this.chars.length, i, i1);
        if (differentFonts) {
            g2.setFont(current);
        }
    }
}

