/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.jlatexmath.awt;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import ru.noties.jlatexmath.awt.BasicStroke;
import ru.noties.jlatexmath.awt.Color;
import ru.noties.jlatexmath.awt.Font;
import ru.noties.jlatexmath.awt.Graphics2D;
import ru.noties.jlatexmath.awt.RenderingHints;
import ru.noties.jlatexmath.awt.Stroke;
import ru.noties.jlatexmath.awt.font.FontRenderContext;
import ru.noties.jlatexmath.awt.geom.AffineTransform;
import ru.noties.jlatexmath.awt.geom.Line2D;
import ru.noties.jlatexmath.awt.geom.Rectangle2D;
import ru.noties.jlatexmath.awt.geom.RoundRectangle2D;

public class AndroidGraphics2D
implements Graphics2D {
    private final RectF rectF = new RectF();
    private final Paint paint = new Paint(1);
    private Canvas canvas;
    private Color color;
    private Stroke stroke;
    private Font font;
    private AffineTransform transform;

    public AndroidGraphics2D() {
        this.paint.setStrokeCap(Paint.Cap.BUTT);
        this.paint.setStrokeJoin(Paint.Join.MITER);
    }

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
        this.transform = AffineTransform.create(canvas);
    }

    @Override
    public Color getColor() {
        if (this.color == null) {
            this.color = new Color(this.paint.getColor());
        }
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.paint.setColor(color.getColorInt());
    }

    @Override
    public void fill(Rectangle2D.Float rectangle2D) {
        this.paint.setStyle(Paint.Style.FILL);
        this.canvas.drawRect(rectangle2D.x, rectangle2D.y, rectangle2D.x + rectangle2D.w, rectangle2D.y + rectangle2D.h, this.paint);
    }

    @Override
    public Stroke getStroke() {
        if (this.stroke == null) {
            this.stroke = new BasicStroke(this.paint.getStrokeWidth(), 0, 0, this.paint.getStrokeMiter());
        }
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.paint.setStrokeWidth(stroke.width());
    }

    @Override
    public AffineTransform getTransform() {
        this.transform = this.transform.save();
        return this.transform;
    }

    @Override
    public void setTransform(AffineTransform at) {
        if (this.canvas != at.getCanvas()) {
            throw new IllegalStateException("Supplied transform has different Canvas attached");
        }
        this.transform = at.restore();
    }

    @Override
    public void draw(Rectangle2D.Float rectangle2D) {
        this.paint.setStyle(Paint.Style.STROKE);
        this.canvas.drawRect(rectangle2D.x, rectangle2D.y, rectangle2D.x + rectangle2D.w, rectangle2D.y + rectangle2D.h, this.paint);
    }

    @Override
    public void translate(double x, double y) {
        this.transform.translate((float)x, (float)y);
    }

    @Override
    public void scale(double x, double y) {
        this.transform.scale(x, y);
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void drawChars(char[] chars, int offset, int length, int x, int y) {
        if (this.font != null) {
            this.paint.setTypeface(this.font.typeface());
            this.paint.setTextSize(this.font.size());
        }
        this.canvas.drawText(chars, offset, length, (float)x, (float)y, this.paint);
    }

    @Override
    public void draw(Line2D.Float line) {
        this.paint.setStyle(Paint.Style.STROKE);
        this.canvas.drawLine((float)line.x1, (float)line.y1, (float)line.x2, (float)line.y2, this.paint);
    }

    @Override
    public void rotate(double theta) {
        this.canvas.rotate((float)Math.toDegrees(theta));
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.canvas.rotate((float)Math.toDegrees(theta), (float)x, (float)y);
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.paint.setStyle(Paint.Style.STROKE);
        this.rectF.set((float)x, (float)y, (float)(x + width), (float)(y + height));
        this.canvas.drawArc(this.rectF, (float)startAngle, (float)arcAngle, false, this.paint);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.paint.setStyle(Paint.Style.FILL);
        this.rectF.set((float)x, (float)y, (float)(x + width), (float)(y + height));
        this.canvas.drawArc(this.rectF, (float)startAngle, (float)arcAngle, false, this.paint);
    }

    @Override
    public void draw(RoundRectangle2D.Float aFloat) {
        this.paint.setStyle(Paint.Style.STROKE);
        this.rectF.set(aFloat.x, aFloat.y, aFloat.x + aFloat.width, aFloat.y + aFloat.height);
        this.canvas.drawRoundRect(this.rectF, aFloat.arcwidth, aFloat.archeight, this.paint);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return null;
    }

    @Override
    public void fillRect(int x, int y, int w, int h) {
        this.paint.setStyle(Paint.Style.FILL);
        this.canvas.drawRect((float)x, (float)y, (float)(x + w), (float)(y + h), this.paint);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key keyAntialiasing, Object valueAntialiasOn) {
    }

    @Override
    public void setRenderingHints(RenderingHints oldHints) {
    }
}

