/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.jlatexmath;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import ru.noties.jlatexmath.JLatexMathAndroid;
import ru.noties.jlatexmath.JLatexMathDrawable;
import ru.noties.jlatexmath.android.R;
import ru.noties.jlatexmath.awt.Color;

public class JLatexMathView
extends View {
    public static final int ALIGN_START = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_END = 2;
    private int textSize;
    private int textColor;
    private Drawable background;
    private int alignVertical;
    private int alignHorizontal;
    private JLatexMathDrawable drawable;
    private float scale;
    private float left;
    private float top;

    public JLatexMathView(Context context) {
        super(context);
        this.init(context, null);
    }

    public JLatexMathView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.JLatexMathView);
        try {
            Drawable background;
            int res = array.getResourceId(R.styleable.JLatexMathView_jlmv_background, 0);
            if (res != 0) {
                String type = context.getResources().getResourceTypeName(res);
                if ("drawable".equals(type)) {
                    background = array.getDrawable(R.styleable.JLatexMathView_jlmv_background);
                } else {
                    if (!"color".equals(type)) throw new IllegalStateException(String.format("Unexpected background reference: %s is of type: %s. Supported: drawable, color", context.getResources().getResourceName(res), type));
                    background = new ColorDrawable(array.getColor(R.styleable.JLatexMathView_jlmv_background, 0));
                }
            } else {
                background = null;
            }
            this.textSize(array.getDimensionPixelSize(R.styleable.JLatexMathView_jlmv_textSize, 0)).textColor(array.getColor(R.styleable.JLatexMathView_jlmv_textColor, Color.black.getColorInt())).background(background).align(array.getInteger(R.styleable.JLatexMathView_jlmv_alignVertical, 0), array.getInteger(R.styleable.JLatexMathView_jlmv_alignHorizontal, 0));
        }
        finally {
            array.recycle();
        }
        if (!this.isInEditMode()) return;
        JLatexMathAndroid.init(context);
        String latex = "\\begin{array}{l}";
        latex = latex + "\\forall\\varepsilon\\in\\mathbb{R}_+^*\\ \\exists\\eta>0\\ |x-x_0|\\leq\\eta\\Longrightarrow|f(x)-f(x_0)|\\leq\\varepsilon\\\\";
        latex = latex + "\\det\\begin{bmatrix}a_{11}&a_{12}&\\cdots&a_{1n}\\\\a_{21}&\\ddots&&\\vdots\\\\\\vdots&&\\ddots&\\vdots\\\\a_{n1}&\\cdots&\\cdots&a_{nn}\\end{bmatrix}\\overset{\\mathrm{def}}{=}\\sum_{\\sigma\\in\\mathfrak{S}_n}\\varepsilon(\\sigma)\\prod_{k=1}^n a_{k\\sigma(k)}\\\\";
        latex = latex + "\\sideset{_\\alpha^\\beta}{_\\gamma^\\delta}{\\begin{pmatrix}a&b\\\\c&d\\end{pmatrix}}\\\\";
        latex = latex + "\\int_0^\\infty{x^{2n} e^{-a x^2}\\,dx} = \\frac{2n-1}{2a} \\int_0^\\infty{x^{2(n-1)} e^{-a x^2}\\,dx} = \\frac{(2n-1)!!}{2^{n+1}} \\sqrt{\\frac{\\pi}{a^{2n+1}}}\\\\";
        latex = latex + "\\int_a^b{f(x)\\,dx} = (b - a) \\sum\\limits_{n = 1}^\\infty  {\\sum\\limits_{m = 1}^{2^n  - 1} {\\left( { - 1} \\right)^{m + 1} } } 2^{ - n} f(a + m\\left( {b - a} \\right)2^{-n} )\\\\";
        latex = latex + "\\int_{-\\pi}^{\\pi} \\sin(\\alpha x) \\sin^n(\\beta x) dx = \\textstyle{\\left \\{ \\begin{array}{cc} (-1)^{(n+1)/2} (-1)^m \\frac{2 \\pi}{2^n} \\binom{n}{m} & n \\mbox{ odd},\\ \\alpha = \\beta (2m-n) \\\\ 0 & \\mbox{otherwise} \\\\ \\end{array} \\right .}\\\\";
        latex = latex + "L = \\int_a^b \\sqrt{ \\left|\\sum_{i,j=1}^ng_{ij}(\\gamma(t))\\left(\\frac{d}{dt}x^i\\circ\\gamma(t)\\right)\\left(\\frac{d}{dt}x^j\\circ\\gamma(t)\\right)\\right|}\\,dt\\\\";
        latex = latex + "\\begin{array}{rl} s &= \\int_a^b\\left\\|\\frac{d}{dt}\\vec{r}\\,(u(t),v(t))\\right\\|\\,dt \\\\ &= \\int_a^b \\sqrt{u'(t)^2\\,\\vec{r}_u\\cdot\\vec{r}_u + 2u'(t)v'(t)\\, \\vec{r}_u\\cdot\\vec{r}_v+ v'(t)^2\\,\\vec{r}_v\\cdot\\vec{r}_v}\\,\\,\\, dt. \\end{array}\\\\";
        latex = latex + "\\end{array}";
        this.setLatex(latex);
    }

    @NonNull
    public JLatexMathView textSize(@Px int textSize) {
        this.textSize = textSize;
        return this;
    }

    @NonNull
    public JLatexMathView textColor(@Px int textColor) {
        this.textColor = textColor;
        return this;
    }

    @NonNull
    public JLatexMathView background(@Nullable Drawable background) {
        this.background = background;
        return this;
    }

    @NonNull
    public JLatexMathView align(@Align int alignVertical, @Align int alignHorizontal) {
        this.alignVertical = alignVertical;
        this.alignHorizontal = alignHorizontal;
        return this;
    }

    public void setLatex(@NonNull String latex) {
        JLatexMathDrawable drawable = JLatexMathDrawable.builder(latex).textSize(this.textSize).color(this.textColor).background(this.background).fitCanvas(false).build();
        this.setLatexDrawable(drawable);
    }

    public void setLatexDrawable(@NonNull JLatexMathDrawable drawable) {
        this.drawable = drawable;
        this.requestLayout();
    }

    public void clear() {
        this.drawable = null;
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int wrap;
        int width;
        if (this.drawable == null) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int drawableWidth = this.drawable.getIntrinsicWidth();
        int drawableHeight = this.drawable.getIntrinsicHeight();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        if (0x40000000 == widthMode) {
            width = widthSize;
        } else {
            wrap = drawableWidth + paddingLeft + this.getPaddingRight();
            int n = width = widthSize > 0 ? Math.min(widthSize, wrap) : wrap;
        }
        if (0x40000000 == heightMode) {
            height = heightSize;
        } else {
            wrap = drawableHeight + paddingTop + this.getPaddingBottom();
            height = heightSize > 0 ? Math.min(heightSize, wrap) : wrap;
        }
        int canvasWidth = width - paddingLeft - this.getPaddingRight();
        int canvasHeight = height - paddingTop - this.getPaddingBottom();
        float scale = drawableWidth < canvasWidth && drawableHeight < canvasHeight ? 1.0f : Math.min((float)canvasWidth / (float)drawableWidth, (float)canvasHeight / (float)drawableHeight);
        int displayWidth = (int)((float)drawableWidth * scale + 0.5f);
        int displayHeight = (int)((float)drawableHeight * scale + 0.5f);
        if (0x40000000 != widthMode) {
            width = displayWidth + paddingLeft + this.getPaddingRight();
        }
        if (0x40000000 != heightMode) {
            height = displayHeight + paddingTop + this.getPaddingBottom();
        }
        float left = JLatexMathView.alignment(this.alignHorizontal, width - paddingLeft - this.getPaddingRight() - displayWidth);
        float top = JLatexMathView.alignment(this.alignVertical, height - paddingTop - this.getPaddingBottom() - displayHeight);
        this.scale = scale;
        this.left = (float)paddingLeft + left;
        this.top = (float)paddingTop + top;
        this.setMeasuredDimension(width, height);
    }

    private static float alignment(int align, float difference) {
        float out = 0 == align ? 0.0f : (1 == align ? difference / 2.0f : difference);
        return out;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.drawable == null) {
            return;
        }
        int save = canvas.save();
        try {
            if (this.left > 0.0f) {
                canvas.translate(this.left, 0.0f);
            }
            if (this.top > 0.0f) {
                canvas.translate(0.0f, this.top);
            }
            if (this.scale > 0.0f && Float.compare(this.scale, 1.0f) != 0) {
                canvas.scale(this.scale, this.scale);
            }
            this.drawable.draw(canvas);
        }
        finally {
            canvas.restoreToCount(save);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Align {
    }
}

