/*
 * Decompiled with CFR 0.152.
 */
package ru.noties.jlatexmath;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import ru.noties.jlatexmath.awt.AndroidGraphics2D;
import ru.noties.jlatexmath.awt.Color;
import ru.noties.jlatexmath.awt.Insets;

public class JLatexMathDrawable
extends Drawable {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    private final TeXIcon icon;
    private final int align;
    private final Drawable background;
    private final AndroidGraphics2D graphics2D;
    private final int iconWidth;
    private final int iconHeight;

    @NonNull
    public static Builder builder(@NonNull String latex) {
        return new Builder(latex);
    }

    JLatexMathDrawable(@NonNull Builder builder) {
        this.icon = new TeXFormula(builder.latex).new TeXFormula.TeXIconBuilder().setFGColor(new Color(builder.color)).setSize(builder.textSize).setStyle(0).build();
        if (builder.insets != null) {
            this.icon.setInsets(builder.insets);
        }
        this.align = builder.align;
        this.background = builder.background;
        this.graphics2D = new AndroidGraphics2D();
        this.iconWidth = this.icon.getIconWidth();
        this.iconHeight = this.icon.getIconHeight();
        this.setBounds(0, 0, this.iconWidth, this.iconHeight);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        if (this.background != null) {
            this.background.setBounds(bounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NonNull Canvas canvas) {
        Rect bounds = this.getBounds();
        int save = canvas.save();
        try {
            if (this.background != null) {
                this.background.draw(canvas);
            }
            int w = bounds.width();
            int h = bounds.height();
            float scale = this.iconWidth > w || this.iconHeight > h ? Math.min((float)w / (float)this.iconWidth, (float)h / (float)this.iconHeight) : 1.0f;
            int targetW = (int)((float)this.iconWidth * scale + 0.5f);
            int targetH = (int)((float)this.iconHeight * scale + 0.5f);
            int top = (h - targetH) / 2;
            int left = this.align == 1 ? (w - targetW) / 2 : (this.align == 2 ? w - targetW : 0);
            if (top != 0 || left != 0) {
                canvas.translate((float)left, (float)top);
            }
            if (Float.compare(scale, 1.0f) != 0) {
                canvas.scale(scale, scale);
            }
            this.graphics2D.setCanvas(canvas);
            this.icon.paintIcon(null, this.graphics2D, 0, 0);
        }
        finally {
            canvas.restoreToCount(save);
        }
    }

    public void setAlpha(int alpha) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public int getOpacity() {
        return -1;
    }

    public int getIntrinsicWidth() {
        return this.iconWidth;
    }

    public int getIntrinsicHeight() {
        return this.iconHeight;
    }

    @NonNull
    public TeXIcon icon() {
        return this.icon;
    }

    public static class Builder {
        private final String latex;
        private float textSize;
        private int color = -16777216;
        private int align;
        private Drawable background;
        private Insets insets;

        public Builder(@NonNull String latex) {
            this.latex = latex;
        }

        @NonNull
        public Builder textSize(@Px float textSize) {
            this.textSize = textSize;
            return this;
        }

        @NonNull
        public Builder color(@ColorInt int color) {
            this.color = color;
            return this;
        }

        @NonNull
        public Builder align(@Align int align) {
            this.align = align;
            return this;
        }

        @NonNull
        public Builder background(@Nullable Drawable background) {
            this.background = background;
            return this;
        }

        @NonNull
        public Builder background(@ColorInt int backgroundColor) {
            this.background = new ColorDrawable(backgroundColor);
            return this;
        }

        @NonNull
        public Builder padding(@Px int padding) {
            this.insets = new Insets(padding, padding, padding, padding);
            return this;
        }

        @NonNull
        public Builder padding(@Px int left, @Px int top, @Px int right, @Px int bottom) {
            this.insets = new Insets(top, left, bottom, right);
            return this;
        }

        @Deprecated
        @NonNull
        public Builder fitCanvas(boolean fitCanvas) {
            return this;
        }

        @NonNull
        public JLatexMathDrawable build() {
            return new JLatexMathDrawable(this);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Align {
    }
}

