/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath.internal.util;

import ru.noties.jlatexmath.awt.Color;
import ru.noties.jlatexmath.awt.image.BufferedImage;

public final class Images {
    public static double DISTANCE_THRESHOLD = 40.0;

    private Images() {
    }

    public static double distance(BufferedImage imgA, BufferedImage imgB) {
        if (imgA.getWidth() == imgB.getWidth() && imgA.getHeight() == imgB.getHeight()) {
            int width = imgA.getWidth();
            int height = imgA.getHeight();
            double mse = 0.0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    Color ca = new Color(imgA.getRGB(x, y));
                    Color cb = new Color(imgB.getRGB(x, y));
                    double variance = Images.sqr(ca.getRed() - cb.getRed()) + Images.sqr(ca.getBlue() - cb.getBlue()) + Images.sqr(ca.getGreen() - cb.getGreen()) + Images.sqr(ca.getAlpha() - cb.getAlpha());
                    mse += variance;
                }
            }
            return Math.sqrt(mse / (double)height / (double)width);
        }
        return -1.0;
    }

    private static double sqr(double x) {
        return x * x;
    }
}

