/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.FramedBox;
import ru.noties.jlatexmath.awt.BasicStroke;
import ru.noties.jlatexmath.awt.Graphics2D;
import ru.noties.jlatexmath.awt.Stroke;
import ru.noties.jlatexmath.awt.geom.Rectangle2D;

public class ShadowBox
extends FramedBox {
    private float shadowRule;

    public ShadowBox(FramedBox fbox, float shadowRule) {
        super(fbox.box, fbox.thickness, fbox.space);
        this.shadowRule = shadowRule;
        this.depth += shadowRule;
        this.width += shadowRule;
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        float th = this.thickness / 2.0f;
        this.box.draw(g2, x + this.space + this.thickness, y);
        Stroke st = g2.getStroke();
        g2.setStroke(new BasicStroke(this.thickness, 0, 0));
        g2.draw(new Rectangle2D.Float(x + th, y - this.height + th, this.width - this.shadowRule - this.thickness, this.height + this.depth - this.shadowRule - this.thickness));
        float penth = (float)Math.abs(1.0 / g2.getTransform().getScaleX());
        g2.setStroke(new BasicStroke(penth, 0, 0));
        g2.fill(new Rectangle2D.Float(x + this.shadowRule - penth, y + this.depth - this.shadowRule - penth, this.width - this.shadowRule, this.shadowRule));
        g2.fill(new Rectangle2D.Float(x + this.width - this.shadowRule - penth, y - this.height + th + this.shadowRule, this.shadowRule, this.depth + this.height - 2.0f * this.shadowRule - th));
        g2.setStroke(st);
    }

    @Override
    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

