/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import ru.noties.jlatexmath.awt.Graphics2D;

public class ScaleBox
extends Box {
    private Box box;
    private double xscl;
    private double yscl;

    public ScaleBox(Box b, double xscl, double yscl) {
        this.box = b;
        this.xscl = Double.isNaN(xscl) || Double.isInfinite(xscl) ? 0.0 : xscl;
        this.yscl = Double.isNaN(yscl) || Double.isInfinite(yscl) ? 0.0 : yscl;
        this.width = b.width * (float)Math.abs(this.xscl);
        this.height = this.yscl > 0.0 ? b.height * (float)this.yscl : -b.depth * (float)this.yscl;
        this.depth = this.yscl > 0.0 ? b.depth * (float)this.yscl : -b.height * (float)this.yscl;
        this.shift = b.shift * (float)this.yscl;
    }

    public ScaleBox(Box b, float factor) {
        this(b, factor, factor);
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        this.drawDebug(g2, x, y);
        if (this.xscl != 0.0 && this.yscl != 0.0) {
            float dec = this.xscl < 0.0 ? this.width : 0.0f;
            g2.translate(x + dec, y);
            g2.scale(this.xscl, this.yscl);
            this.box.draw(g2, 0.0f, 0.0f);
            g2.scale(1.0 / this.xscl, 1.0 / this.yscl);
            g2.translate(-x - dec, -y);
        }
    }

    @Override
    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

