/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import ru.noties.jlatexmath.awt.Graphics2D;
import ru.noties.jlatexmath.awt.geom.AffineTransform;

public class OverUnderBox
extends Box {
    private final Box base;
    private final Box del;
    private final Box script;
    private final float kern;
    private final boolean over;

    public OverUnderBox(Box b, Box d, Box script, float kern, boolean over) {
        this.base = b;
        this.del = d;
        this.script = script;
        this.kern = kern;
        this.over = over;
        this.width = b.getWidth();
        this.height = b.height + (over ? d.getWidth() : 0.0f) + (over && script != null ? script.height + script.depth + kern : 0.0f);
        this.depth = b.depth + (over ? 0.0f : d.getWidth()) + (!over && script != null ? script.height + script.depth + kern : 0.0f);
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        AffineTransform oldAt;
        double transY;
        double transX;
        this.drawDebug(g2, x, y);
        this.base.draw(g2, x, y);
        float yVar = y - this.base.height - this.del.getWidth();
        this.del.setDepth(this.del.getHeight() + this.del.getDepth());
        this.del.setHeight(0.0f);
        if (this.over) {
            transX = (double)x + (double)(this.del.height + this.del.depth) * 0.75;
            transY = yVar;
            oldAt = g2.getTransform();
            g2.translate(transX, transY);
            g2.rotate(1.5707963267948966);
            this.del.draw(g2, 0.0f, 0.0f);
            g2.setTransform(oldAt);
            if (this.script != null) {
                this.script.draw(g2, x, yVar - this.kern - this.script.depth);
            }
        }
        yVar = y + this.base.depth;
        if (!this.over) {
            transX = (double)x + (double)(this.del.getHeight() + this.del.depth) * 0.75;
            transY = yVar;
            oldAt = g2.getTransform();
            g2.translate(transX, transY);
            g2.rotate(1.5707963267948966);
            this.del.draw(g2, 0.0f, 0.0f);
            g2.setTransform(oldAt);
            yVar += this.del.getWidth();
            if (this.script != null) {
                this.script.draw(g2, x, yVar + this.kern + this.script.height);
            }
        }
    }

    @Override
    public int getLastFontId() {
        return this.base.getLastFontId();
    }
}

