/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import ru.noties.jlatexmath.awt.Font;
import ru.noties.jlatexmath.awt.Graphics2D;
import ru.noties.jlatexmath.awt.font.TextLayout;
import ru.noties.jlatexmath.awt.geom.Rectangle2D;

public class JavaFontRenderingBox
extends Box {
    private static Font font = new Font("Serif", 0, 10);
    private TextLayout text;
    private float size;

    public JavaFontRenderingBox(String str, int type, float size, Font f, boolean kerning) {
        this.size = size;
        this.text = new TextLayout(str, f.deriveFont(type), null);
        Rectangle2D rect = this.text.getBounds();
        this.height = -rect.getY() * size / 10.0f;
        this.depth = rect.getHeight() * size / 10.0f - this.height;
        this.width = (rect.getWidth() + rect.getX() + 0.4f) * size / 10.0f;
    }

    public JavaFontRenderingBox(String str, int type, float size) {
        this(str, type, size, font, true);
    }

    public static void setFont(String name) {
        font = new Font(name, 0, 10);
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        this.drawDebug(g2, x, y);
        g2.translate(x, y);
        g2.scale(0.1 * (double)this.size, 0.1 * (double)this.size);
        this.text.draw(g2, 0, 0);
        g2.scale(10.0f / this.size, 10.0f / this.size);
        g2.translate(-x, -y);
    }

    @Override
    public int getLastFontId() {
        return 0;
    }
}

