/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import ru.noties.jlatexmath.awt.Color;
import ru.noties.jlatexmath.awt.Graphics2D;
import ru.noties.jlatexmath.awt.geom.Rectangle2D;

public class HorizontalRule
extends Box {
    private Color color = null;
    private float speShift = 0.0f;

    public HorizontalRule(float thickness, float width, float s) {
        this.height = thickness;
        this.width = width;
        this.shift = s;
    }

    public HorizontalRule(float thickness, float width, float s, boolean trueShift) {
        this.height = thickness;
        this.width = width;
        if (trueShift) {
            this.shift = s;
        } else {
            this.shift = 0.0f;
            this.speShift = s;
        }
    }

    public HorizontalRule(float thickness, float width, float s, Color c) {
        this.height = thickness;
        this.width = width;
        this.color = c;
        this.shift = s;
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        Color old = g2.getColor();
        if (this.color != null) {
            g2.setColor(this.color);
        }
        if (this.speShift == 0.0f) {
            g2.fill(new Rectangle2D.Float(x, y - this.height, this.width, this.height));
        } else {
            g2.fill(new Rectangle2D.Float(x, y - this.height + this.speShift, this.width, this.height));
        }
        g2.setColor(old);
    }

    @Override
    public int getLastFontId() {
        return -1;
    }
}

