/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Box;
import ru.noties.jlatexmath.awt.BasicStroke;
import ru.noties.jlatexmath.awt.Graphics2D;
import ru.noties.jlatexmath.awt.Stroke;
import ru.noties.jlatexmath.awt.geom.AffineTransform;
import ru.noties.jlatexmath.awt.geom.Line2D;

public class FcscoreBox
extends Box {
    private int N;
    private boolean strike;
    private float space;
    private float thickness;

    public FcscoreBox(int N, float h, float thickness, float space, boolean strike) {
        this.N = N;
        this.width = (float)N * (thickness + space) + 2.0f * space;
        this.height = h;
        this.depth = 0.0f;
        this.strike = strike;
        this.space = space;
        this.thickness = thickness;
    }

    @Override
    public void draw(Graphics2D g2, float x, float y) {
        AffineTransform transf = g2.getTransform();
        Stroke oldStroke = g2.getStroke();
        double sx = transf.getScaleX();
        double sy = transf.getScaleY();
        double s = 1.0;
        if (sx == sy) {
            s = sx;
            AffineTransform t = transf.clone();
            t.scale(1.0 / sx, 1.0 / sy);
            g2.setTransform(t);
        }
        g2.setStroke(new BasicStroke((float)(s * (double)this.thickness), 0, 0));
        float th = this.thickness / 2.0f;
        Line2D.Float line = new Line2D.Float();
        float xx = x + this.space;
        xx = (float)((double)xx * s + (double)(this.space / 2.0f) * s);
        int inc = (int)Math.round((double)(this.space + this.thickness) * s);
        for (int i = 0; i < this.N; ++i) {
            line.setLine((double)xx + (double)th * s, (double)(y - this.height) * s, (double)xx + (double)th * s, (double)y * s);
            g2.draw(line);
            xx += (float)inc;
        }
        if (this.strike) {
            line.setLine((double)(x + this.space) * s, (double)(y - this.height / 2.0f) * s, (double)xx - s * (double)this.space / 2.0, (double)(y - this.height / 2.0f) * s);
            g2.draw(line);
        }
        g2.setTransform(transf);
        g2.setStroke(oldStroke);
    }

    @Override
    public int getLastFontId() {
        return -1;
    }
}

